/*
 * Decompiled with CFR 0.152.
 */
package cn.yueshutong.springbootstartercurrentlimiting.aspect;

import cn.yueshutong.springbootstartercurrentlimiting.annotation.CurrentLimiter;
import cn.yueshutong.springbootstartercurrentlimiting.common.SpringContextUtil;
import cn.yueshutong.springbootstartercurrentlimiting.core.RateLimiter;
import cn.yueshutong.springbootstartercurrentlimiting.core.RateLimiterCloud;
import cn.yueshutong.springbootstartercurrentlimiting.core.RateLimiterSingle;
import cn.yueshutong.springbootstartercurrentlimiting.handler.CurrentAspectHandler;
import cn.yueshutong.springbootstartercurrentlimiting.properties.CurrentProperties;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@Aspect
@ConditionalOnProperty(prefix="current.limiting", name={"part-enabled"}, havingValue="true", matchIfMissing=true)
public class CurrentAspect {
    private Map<String, RateLimiter> map = new ConcurrentHashMap<String, RateLimiter>();
    @Autowired(required=false)
    private CurrentAspectHandler handler;
    @Autowired
    private CurrentProperties properties;

    @Pointcut(value="@annotation(cn.yueshutong.springbootstartercurrentlimiting.annotation.CurrentLimiter)")
    public void pointcut() {
    }

    @Around(value="pointcut() && @annotation(currentLimiter)")
    public Object around(ProceedingJoinPoint pjp, CurrentLimiter currentLimiter) throws Throwable {
        RateLimiter rateLimiter = this.initCurrentLimiting(pjp, currentLimiter);
        if (currentLimiter.failFast()) {
            return this.tryAcquireFailed(pjp, currentLimiter, rateLimiter);
        }
        rateLimiter.tryAcquire();
        return pjp.proceed();
    }

    private Object tryAcquireFailed(ProceedingJoinPoint pjp, CurrentLimiter currentLimiter, RateLimiter rateLimiter) throws Throwable {
        if (rateLimiter.tryAcquireFailed()) {
            return pjp.proceed();
        }
        return this.handler == null ? "<pre>The specified service is not currently available.</pre>" : this.handler.around(pjp, currentLimiter);
    }

    private RateLimiter initCurrentLimiting(ProceedingJoinPoint pjp, CurrentLimiter currentLimiter) {
        String key = pjp.getSignature().toLongString();
        if (!this.map.containsKey(key)) {
            if (this.properties.isCloudEnabled()) {
                this.map.put(key, RateLimiterCloud.of(currentLimiter.QPS(), currentLimiter.initialDelay(), SpringContextUtil.getApplicationName() + key));
            } else {
                this.map.put(key, RateLimiterSingle.of(currentLimiter.QPS(), currentLimiter.initialDelay()));
            }
        }
        return this.map.get(key);
    }
}

