/*
 * Decompiled with CFR 0.152.
 */
package cn.yueshutong.springbootstartercurrentlimiting.interceptor;

import cn.yueshutong.springbootstartercurrentlimiting.common.CurrentEnum;
import cn.yueshutong.springbootstartercurrentlimiting.core.RateLimiter;
import cn.yueshutong.springbootstartercurrentlimiting.handler.CurrentInterceptorHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;

public class CurrentInterceptor
implements HandlerInterceptor {
    private RateLimiter currentLimiter;
    private boolean failFast;
    private CurrentInterceptorHandler interceptorHandler;

    public CurrentInterceptor(RateLimiter currentLimiter, boolean failFast, CurrentInterceptorHandler handler) {
        this.currentLimiter = currentLimiter;
        this.failFast = failFast;
        this.interceptorHandler = handler;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.failFast) {
            return this.tryAcquireFailed(request, response, handler);
        }
        return this.currentLimiter.tryAcquire();
    }

    private boolean tryAcquireFailed(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.currentLimiter.tryAcquireFailed()) {
            return true;
        }
        if (this.interceptorHandler == null) {
            response.getWriter().print(CurrentEnum.MESSAGE.getMessage());
        } else {
            this.interceptorHandler.preHandle(request, response, handler);
        }
        return false;
    }
}

