/*
 * Decompiled with CFR 0.152.
 */
package cn.yueshutong.springbootstartercurrentlimiting.core;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class RateLimiter {
    private long QPS;
    private long period;
    private long initialDelay;
    private AtomicLong bucket = new AtomicLong(0L);

    private RateLimiter(long QPS, long initialDelay) {
        this.QPS = QPS;
        this.initialDelay = initialDelay;
        this.period = QPS > 0L ? 1000L / QPS : Integer.MAX_VALUE;
        this.scheduled();
    }

    public static RateLimiter of(long QPS) {
        return new RateLimiter(QPS, 0L);
    }

    public static RateLimiter of(long QPS, long initialDelay) {
        return new RateLimiter(QPS, initialDelay);
    }

    public boolean tryAcquire() {
        long l = this.bucket.longValue();
        while (l <= 0L || !this.bucket.compareAndSet(l, l - 1L)) {
            l = this.bucket.longValue();
        }
        return true;
    }

    public boolean tryAcquireFailed() {
        long l = this.bucket.longValue();
        while (l > 0L) {
            if (this.bucket.compareAndSet(l, l - 1L)) {
                return true;
            }
            l = this.bucket.longValue();
        }
        return false;
    }

    private void scheduled() {
        ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
        service.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (RateLimiter.this.QPS > RateLimiter.this.bucket.longValue()) {
                    RateLimiter.this.bucket.incrementAndGet();
                }
            }
        }, this.initialDelay, this.period, TimeUnit.MILLISECONDS);
    }
}

