/*
 * Decompiled with CFR 0.152.
 */
package cn.yueshutong.springbootstartercurrentlimiting.aspect;

import cn.yueshutong.springbootstartercurrentlimiting.annotation.CurrentLimiter;
import cn.yueshutong.springbootstartercurrentlimiting.common.CurrentEnum;
import cn.yueshutong.springbootstartercurrentlimiting.core.RateLimiter;
import cn.yueshutong.springbootstartercurrentlimiting.handler.CurrentAspectHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@Aspect
@ConditionalOnProperty(prefix="current.limiting", name={"part-enabled"}, havingValue="true", matchIfMissing=true)
public class CurrentAspect {
    private Map<String, RateLimiter> map = new ConcurrentHashMap<String, RateLimiter>();
    @Autowired(required=false)
    private CurrentAspectHandler handler;

    @Pointcut(value="@annotation(cn.yueshutong.springbootstartercurrentlimiting.annotation.CurrentLimiter)")
    public void pointcut() {
    }

    @Around(value="pointcut() && @annotation(currentLimiter)")
    public Object around(ProceedingJoinPoint pjp, CurrentLimiter currentLimiter) throws Throwable {
        String key = pjp.getSignature().toLongString();
        if (!this.map.containsKey(key)) {
            this.map.put(key, RateLimiter.of(currentLimiter.QPS(), currentLimiter.initialDelay()));
        }
        RateLimiter rateLimiter = this.map.get(key);
        if (currentLimiter.failFast()) {
            return this.tryAcquireFailed(pjp, currentLimiter, rateLimiter);
        }
        rateLimiter.tryAcquire();
        return pjp.proceed();
    }

    private Object tryAcquireFailed(ProceedingJoinPoint pjp, CurrentLimiter currentLimiter, RateLimiter rateLimiter) throws Throwable {
        if (rateLimiter.tryAcquireFailed()) {
            return pjp.proceed();
        }
        return this.handler == null ? CurrentEnum.MESSAGE.getMessage() : this.handler.around(pjp, currentLimiter);
    }
}

