/*
 * Decompiled with CFR 0.152.
 */
package cn.yueshutong.executor;

import cn.yueshutong.Callable.AiPaCallable;
import cn.yueshutong.util.AiPaUtil;
import cn.yueshutong.worker.AiPaWorker;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jsoup.Connection;

public class AiPaExecutor {
    private AiPaWorker aiPaWorker;
    private ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() + 1);
    private int maxFailCount = 5;
    private Charset charset = Charset.forName("UTF-8");
    private Map<String, String> header = null;
    private Map<String, String> cookies = null;
    private String userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.143 Safari/537.36";
    private int timeout = 30000;
    private Connection.Method method = Connection.Method.GET;
    private List<Future> futureList = new Vector<Future>();

    public AiPaExecutor(AiPaWorker aiPaWorker) {
        this.aiPaWorker = aiPaWorker;
    }

    public void submit(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.futureList.add(this.executor.submit(new AiPaCallable().init(this.aiPaWorker, this.maxFailCount, list.get(i), this.charset, this.header, this.method, this.timeout, this.userAgent, this.cookies)));
        }
    }

    public void submit(List<String> list, Class<? extends AiPaUtil> aiPaUtil) throws IllegalAccessException, InstantiationException {
        for (int i = 0; i < list.size(); ++i) {
            this.futureList.add(this.executor.submit(new AiPaCallable().init(this.aiPaWorker, this.maxFailCount, list.get(i), aiPaUtil.newInstance())));
        }
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public List<Future> getFutureList() {
        return this.futureList;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public AiPaExecutor setThreads(int threads) {
        this.executor = Executors.newFixedThreadPool(threads);
        return this;
    }

    public AiPaExecutor setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public AiPaExecutor setMaxFailCount(int maxFailCount) {
        this.maxFailCount = maxFailCount;
        return this;
    }

    public AiPaExecutor setHeader(Map<String, String> header) {
        this.header = header;
        return this;
    }

    public AiPaExecutor setMethod(Connection.Method method) {
        this.method = method;
        return this;
    }

    public AiPaExecutor setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public AiPaExecutor setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public AiPaExecutor setCookies(Map<String, String> cookies) {
        this.cookies = cookies;
        return this;
    }
}

