/*
 * Decompiled with CFR 0.152.
 */
package cn.yueshutong.Callable;

import cn.yueshutong.util.AiPaUtil;
import cn.yueshutong.worker.AiPaWorker;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jsoup.Connection;
import org.jsoup.nodes.Document;

public class AiPaCallable
implements Callable<Object> {
    private AiPaWorker aiPaWorker;
    private int maxFailCount;
    private String link;
    private AiPaUtil aiPaUtil;

    public AiPaCallable init(AiPaWorker aiPaWorker, int maxFailCount, String link, AiPaUtil aiPaUtil) {
        this.aiPaWorker = aiPaWorker;
        this.maxFailCount = maxFailCount;
        this.link = link;
        this.aiPaUtil = aiPaUtil;
        return this;
    }

    public AiPaCallable init(AiPaWorker aiPaWorker, int maxFailCount, String link, Charset charset, Map<String, String> header, Connection.Method method, int timeout, String userAgent, Map<String, String> cookies) {
        this.aiPaWorker = aiPaWorker;
        this.maxFailCount = maxFailCount;
        this.link = link;
        this.aiPaUtil = new AiPaUtil(charset, header, method, timeout, userAgent, cookies);
        return this;
    }

    @Override
    public Object call() {
        int c = 0;
        while (c < this.maxFailCount) {
            try {
                Document body = this.aiPaUtil.getHtmlDocument(this.link);
                return this.aiPaWorker.run(body, this.aiPaUtil);
            }
            catch (IOException e) {
                if (++c != this.maxFailCount) continue;
                e.printStackTrace();
            }
        }
        return this.aiPaWorker.fail(this.link);
    }
}

