/*
 * Decompiled with CFR 0.152.
 */
package cn.yt4j.swagger;

import cn.yt4j.swagger.condition.SwaggerCondition;
import cn.yt4j.swagger.property.SwaggerProperty;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@EnableAutoConfiguration
@EnableConfigurationProperties(value={SwaggerProperty.class})
@Conditional(value={SwaggerCondition.class})
@ConditionalOnProperty(name={"snake.swagger.enabled"}, matchIfMissing=true)
public class SwaggerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SwaggerProperty swaggerProperty() {
        return new SwaggerProperty();
    }

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)this.swaggerProperty().getBasePackage())).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.swaggerProperty().getTitle()).contact(new Contact(this.swaggerProperty().getContact().getName(), this.swaggerProperty().getContact().getUrl(), this.swaggerProperty().getContact().getEmail())).version(this.swaggerProperty().getVersion()).description(this.swaggerProperty().getDescription()).build();
    }
}

