/*
 * Decompiled with CFR 0.152.
 */
package cn.yt4j.qiniu.service.impl;

import cn.yt4j.qiniu.property.QiNiuProperties;
import cn.yt4j.qiniu.service.QiNiuService;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QiNiuServiceImpl
implements QiNiuService {
    @Autowired
    private UploadManager uploadManager;
    @Autowired
    private BucketManager bucketManager;
    @Autowired
    private Auth auth;
    @Autowired
    private QiNiuProperties qiNiuProperties;

    @Override
    public Response uploadStream(InputStream stream, String key, boolean existed) throws QiniuException {
        Response response;
        if (existed) {
            response = this.uploadManager.put(stream, key, this.getUploadToken(key), null, null);
        } else {
            response = this.uploadManager.put(stream, key, this.getUploadToken(), null, null);
            for (int retry = 0; response.needRetry() && retry < 3; ++retry) {
                response = this.uploadManager.put(stream, key, this.getUploadToken(), null, null);
            }
        }
        return response;
    }

    private String getUploadToken(String fileName) {
        return this.auth.uploadToken(this.qiNiuProperties.getBucketName(), fileName);
    }

    @Override
    public void deleteFile(String key) throws QiniuException {
        this.bucketManager.delete(this.qiNiuProperties.getBucketName(), key);
    }

    @Override
    public String getUploadToken() throws QiniuException {
        return this.auth.uploadToken(this.qiNiuProperties.getBucketName());
    }
}

