/*
 * Decompiled with CFR 0.152.
 */
package cn.yt4j.qiniu;

import cn.yt4j.qiniu.condition.QiNiuCondition;
import cn.yt4j.qiniu.property.QiNiuProperties;
import cn.yt4j.qiniu.service.QiNiuService;
import cn.yt4j.qiniu.service.impl.QiNiuServiceImpl;
import com.qiniu.common.Zone;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;

@org.springframework.context.annotation.Configuration
@EnableAutoConfiguration
@EnableConfigurationProperties(value={QiNiuProperties.class})
@Conditional(value={QiNiuCondition.class})
@ConditionalOnProperty(name={"snake.qiniu.enabled"}, matchIfMissing=true)
public class QiNiuAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(QiNiuAutoConfiguration.class);
    @Autowired
    private QiNiuProperties qiNiuYunProperties;

    @Bean
    @ConditionalOnMissingBean(value={QiNiuServiceImpl.class})
    public QiNiuService qiNiuYunService() {
        return new QiNiuServiceImpl();
    }

    @Bean
    public UploadManager uploadManager() {
        Configuration conf = new Configuration(Zone.autoZone());
        return new UploadManager(conf);
    }

    @Bean
    public Auth auth() {
        return Auth.create((String)this.qiNiuYunProperties.getAccessKey(), (String)this.qiNiuYunProperties.getSecretKey());
    }

    @Bean
    public BucketManager bucketManager() {
        Configuration conf = new Configuration(Zone.autoZone());
        return new BucketManager(this.auth(), conf);
    }
}

