/*
 * Decompiled with CFR 0.152.
 */
package cn.yogehaoren;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchProxySelector
extends ProxySelector {
    private static final Logger logger = LoggerFactory.getLogger(SwitchProxySelector.class);
    public static ThreadLocal<Proxy> proxyThreadLocal = new ThreadLocal();
    private static final Pattern PROXY_PATTERN = Pattern.compile("(socket|http):(.*):(.*)");

    @Override
    public List<Proxy> select(URI uri) {
        Proxy proxy = proxyThreadLocal.get();
        if (proxy == null) {
            proxy = Proxy.NO_PROXY;
        }
        logger.debug("{} use proxy {}:{}", new Object[]{uri.toString(), proxy.type().name(), proxy.address()});
        proxyThreadLocal.remove();
        return Collections.singletonList(proxy);
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }

    static Proxy getProxy(String proxyString) {
        if (proxyString == null || "".equals(proxyString)) {
            return Proxy.NO_PROXY;
        }
        Matcher matcher = PROXY_PATTERN.matcher(proxyString);
        if (matcher.matches()) {
            switch (matcher.group(1)) {
                case "socket": {
                    return new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(matcher.group(2), Integer.parseInt(matcher.group(3))));
                }
                case "http": {
                    return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(matcher.group(2), Integer.parseInt(matcher.group(3))));
                }
            }
            return Proxy.NO_PROXY;
        }
        return Proxy.NO_PROXY;
    }
}

