/*
 * Decompiled with CFR 0.152.
 */
package cn.yogehaoren;

import cn.yogehaoren.SwitchProxySelector;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchProxyInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(SwitchProxyInterceptor.class);

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        if (chain.request().header("meta.proxy") != null) {
            logger.debug("detect proxy header : {}", (Object)chain.request().header("meta.proxy"));
            SwitchProxySelector.proxyThreadLocal.set(SwitchProxySelector.getProxy(chain.request().header("meta.proxy")));
            Request newRequest = chain.request().newBuilder().removeHeader("meta.proxy").build();
            return chain.proceed(newRequest);
        }
        return chain.proceed(chain.request());
    }
}

