package cn.yogehaoren;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

/**
 * @author WangNing yogehaoren@gmial.com <br>
 * @since 1.0
 */
public class SwitchProxyInterceptor implements Interceptor {

    private final static Logger logger = LoggerFactory.getLogger(SwitchProxyInterceptor.class);

    @NotNull
    public Response intercept(@NotNull Chain chain) throws IOException {

        if(chain.request().header("meta.proxy")!=null){
            logger.debug("detect proxy header : {}", chain.request().header("meta.proxy"));
            SwitchProxySelector.proxyThreadLocal.set(SwitchProxySelector.getProxy(chain.request().header("meta.proxy")));
            Request newRequest = chain.request().newBuilder().removeHeader("meta.proxy").build();

            return chain.proceed(newRequest);
        }

        return chain.proceed(chain.request());

    }



}
