package cn.yogehaoren;

import okhttp3.OkHttpClient;
import okhttp3.OkHttpClient.Builder;

import java.util.concurrent.TimeUnit;

/**
 * @author WangNing
 * @since 1.0
 */
public class OkhttpClientFactory {

    private static OkHttpClient client = null;


    private OkhttpClientFactory(){ }

    public static OkHttpClient getInstance(){

        if( client  == null){
            synchronized (OkhttpClientFactory.class){
                if (client == null) {
                    client = new Builder()
                            .readTimeout(20, TimeUnit.SECONDS)
                            .callTimeout(5, TimeUnit.SECONDS)
                            .connectTimeout(5, TimeUnit.SECONDS)
                            .build();
                }
                return client;
            }
        }else{
            return client;
        }


    }

}
