package cn.yogehaoren;

import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;

/**
 * @author WangNing
 * @since 1.0
 */
public class HttpGet {

    public static String getString(String url, Map<String, String> params, Map<String, String> headers) throws IOException {
        HttpUrl.Builder builder = null;
        try{
            builder = Objects.requireNonNull(HttpUrl.parse(url)).newBuilder();
        }catch (NullPointerException e){
            return null;
        }

        if(params!=null){
            params.forEach(builder::addQueryParameter);
        }
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(builder.toString());
        if(headers!=null){
            headers.forEach(requestBuilder::addHeader);
        }

        OkHttpClient client = OkhttpClientFactory.getInstance();
        try(Response response = client.newCall(requestBuilder.build()).execute()){
            if (response.body() == null){
                return null;
            }

            return response.body().string();
        }
    }

}
