package cn.yogehaoren.gateway_resource_starter;


import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author WangNing
 * @since 1.0
 */

@ConfigurationProperties("static-rewrite")
public class StaticResourceProperties {

    /** 是否开启自动路径配置  */
    private boolean enabled = true;

    /** 静态资源配置，key 表示路径规则，value 表示转发地址 */
    private Map<String, String> staticResources = new LinkedHashMap<>();

    public Map<String, String> getStaticResources() {
        return staticResources;
    }

}
