package cn.yogehaoren.gateway_resource_starter;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.*;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gateway.config.GatewayAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;

import java.util.Map;

/**
 * @author WangNing
 * @since 1.0
 */

@Configuration
@EnableConfigurationProperties(StaticResourceProperties.class)
@ConditionalOnProperty(prefix = "static-rewrite", value = "enabled", matchIfMissing = true)
@ConditionalOnClass({ServerResponse.class, ResourceLoader.class, RouterFunction.class })
@AutoConfigureAfter({GatewayAutoConfiguration.class})
public class StaticResourceAutoConfiguration {

    private static final Logger logger = LoggerFactory.getLogger(StaticResourceAutoConfiguration.class);

    private StaticResourceProperties properties;

    public StaticResourceAutoConfiguration(StaticResourceProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(name = "staticResources")
    public Map<String, String> staticResources() {
        return properties.getStaticResources();
    }

    @Bean
    @ConditionalOnBean(name = "staticResources", value = Map.class)
    public RouterFunction<ServerResponse> staticResourceLocator(ResourceLoader resourceLoader,
                                                                Map<String, String> staticResources) {
        //空 `Map` 其实不需要启用配置，但没有 `@ConditionalOnNotEmptyBean` 这种注解， https://stackoverflow.com/questions/62734544/spring-conditionalonproperty-for-bean[此问题^] 待优化
        if (staticResources.isEmpty()) return null;
        RouterFunctions.Builder builder = RouterFunctions.route();
        staticResources.forEach((key, value) -> {
            logger.debug("添加静态资源配置: [{}] -> [{}]", key, value);
            builder.add(RouterFunctions.resources(key, resourceLoader.getResource(value)));
        });
        return builder.build();
    }

}
