/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.workflow;

import cn.ymotel.dactor.ActorUtils;
import cn.ymotel.dactor.core.ActorChainCfg;
import cn.ymotel.dactor.core.ActorTransactionCfg;
import cn.ymotel.dactor.message.AsyncMessage;
import cn.ymotel.dactor.message.Message;
import cn.ymotel.dactor.message.SpringControlMessage;
import cn.ymotel.dactor.workflow.ActorProcessStructure;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ognl.Node;
import ognl.Ognl;
import ognl.OgnlContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class WorkFlowProcess {
    private static final Log logger = LogFactory.getLog(WorkFlowProcess.class);

    public static void PushActorsToStackWithChain(Deque<ActorProcessStructure> actorStack, ActorTransactionCfg cfg, ActorChainCfg chain) {
        WorkFlowProcess.AppendCfg2Deque(cfg, actorStack);
    }

    public static void PushActorsToStack(Deque<ActorProcessStructure> actorStack, ActorTransactionCfg cfg) {
        WorkFlowProcess.AppendCfg2Deque(cfg, actorStack);
    }

    public static Deque<ActorProcessStructure> createActorsStack() {
        return new ArrayDeque<ActorProcessStructure>();
    }

    public static void processGetToBeanId(SpringControlMessage control, Message message, ApplicationContext appcontext) {
        Deque<ActorProcessStructure> actorStack = control.getActorsStack();
        Deque<ActorProcessStructure> downStack = control.getDownStack();
        if (actorStack.isEmpty() && downStack.isEmpty()) {
            return;
        }
        WorkFlowProcess.FireNextMessage(actorStack, downStack, message, appcontext);
    }

    public static void AppendCfg2Deque(ActorTransactionCfg cfg, Deque<ActorProcessStructure> deque) {
        deque.push(WorkFlowProcess.InitActorProcessStructure(cfg));
        if (cfg.getParent() != null) {
            WorkFlowProcess.AppendCfg2Deque(cfg.getParent(), deque);
        }
        if (cfg.getChain() != null) {
            for (int i = cfg.getChain().getChain().size(); i > 0; --i) {
                deque.push(WorkFlowProcess.InitActorProcessStructure(cfg.getChain().getChain().get(i - 1)));
            }
        }
    }

    private static ActorProcessStructure InitActorProcessStructure(ActorTransactionCfg cfg) {
        ActorProcessStructure tmpstrunc = new ActorProcessStructure();
        tmpstrunc.setActorTransactionCfg(cfg);
        tmpstrunc.setFromBeanId(cfg.getBeginBeanId());
        return tmpstrunc;
    }

    public static void FireNextMessage(Deque<ActorProcessStructure> deque, Deque<ActorProcessStructure> downdeque, Message message, ApplicationContext appcontext) {
        Object bean;
        if (downdeque.isEmpty()) {
            return;
        }
        ActorProcessStructure strunc = downdeque.peek();
        if (strunc == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("beanId--" + strunc.getFromBeanId() + "--Id--" + strunc.getActorTransactionCfg().getId()));
        }
        if (!strunc.isBeginExecute()) {
            strunc.setFromBeanId(strunc.getActorTransactionCfg().getBeginBeanId());
            return;
        }
        if (strunc.isEndExecute()) {
            strunc.setFromBeanId(null);
            if (!downdeque.isEmpty()) {
                downdeque.pop();
                WorkFlowProcess.FireNextMessage(deque, downdeque, message, appcontext);
                return;
            }
            return;
        }
        Throwable throwable = message.getException();
        if (throwable != null && !strunc.getActorTransactionCfg().isHandleException()) {
            strunc.setFromBeanId(message.getControlMessage().getProcessStructure().getActorTransactionCfg().getEndBeanId());
            downdeque.pop();
            WorkFlowProcess.FireNextMessage(deque, downdeque, message, appcontext);
            return;
        }
        String beanId = WorkFlowProcess.getBeanIdFromStep(strunc, message);
        if (beanId == null) {
            return;
        }
        String asyncBeanId = WorkFlowProcess.getAsyncBeanIdFromStep(strunc, message);
        if (asyncBeanId != null) {
            WorkFlowProcess.SendAsyncMessage(message, appcontext, asyncBeanId);
        }
        strunc.setFromBeanId(beanId);
        if (beanId.equals(strunc.getActorTransactionCfg().getEndBeanId())) {
            strunc.setEndExecute(true);
        }
        if ((bean = ActorUtils.getCacheBean(appcontext, beanId)) instanceof ActorTransactionCfg) {
            WorkFlowProcess.AppendCfg2Deque((ActorTransactionCfg)bean, deque);
            downdeque.push(deque.pop());
            WorkFlowProcess.FireNextMessage(deque, downdeque, message, appcontext);
            return;
        }
    }

    public static String getBeanIdFromStep(ActorProcessStructure struncture, Message message) {
        if (struncture == null) {
            return null;
        }
        Map condtions = struncture.getActorTransactionCfg().getSteps();
        if (condtions == null || condtions.isEmpty()) {
            return struncture.getActorTransactionCfg().getEndBeanId();
        }
        List fromBeanIdCondtions = (List)condtions.get(struncture.getFromBeanId());
        if (fromBeanIdCondtions == null || fromBeanIdCondtions.isEmpty()) {
            return struncture.getActorTransactionCfg().getEndBeanId();
        }
        for (int i = 0; i < fromBeanIdCondtions.size(); ++i) {
            Map tmpMap = (Map)fromBeanIdCondtions.get(i);
            Object condtion = tmpMap.get("conditon");
            String toBeanId = (String)tmpMap.get("toBeanId");
            String async = (String)tmpMap.get("async");
            boolean isTrue = WorkFlowProcess.getConditonValue(message, condtion);
            if (!isTrue) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Condtion---" + condtion));
            }
            struncture.setStepMap(tmpMap);
            return toBeanId;
        }
        return struncture.getActorTransactionCfg().getEndBeanId();
    }

    public static String getAsyncBeanIdFromStep(ActorProcessStructure struncture, Message message) {
        if (struncture == null) {
            return null;
        }
        Map condtions = struncture.getActorTransactionCfg().getAsyncSteps();
        if (condtions == null || condtions.isEmpty()) {
            return null;
        }
        List fromBeanIdCondtions = (List)condtions.get(struncture.getFromBeanId());
        if (fromBeanIdCondtions == null || fromBeanIdCondtions.isEmpty()) {
            return null;
        }
        for (int i = 0; i < fromBeanIdCondtions.size(); ++i) {
            Map tmpMap = (Map)fromBeanIdCondtions.get(i);
            Object condtion = tmpMap.get("conditon");
            String toBeanId = (String)tmpMap.get("toBeanId");
            boolean isTrue = WorkFlowProcess.getConditonValue(message, condtion);
            if (!isTrue) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Condtion---" + condtion));
            }
            return toBeanId;
        }
        return null;
    }

    private static void SendAsyncMessage(Message message, ApplicationContext appcontext, String toBeanId) {
        block2: {
            ActorTransactionCfg cfg = (ActorTransactionCfg)ActorUtils.getCacheBean(appcontext, toBeanId);
            AsyncMessage asyncMessage = new AsyncMessage(message.getContext());
            try {
                message.getControlMessage().getMessageDispatcher().startMessage((Message)asyncMessage, cfg, true);
            }
            catch (Exception e) {
                if (!logger.isTraceEnabled()) break block2;
                logger.trace((Object)"processGetToBeanId(SpringControlMessage, Message, ApplicationContext)");
            }
        }
    }

    private static boolean getConditonValue(Message message, Object condtion) {
        if (condtion == null || condtion.equals("")) {
            return true;
        }
        Node node = (Node)condtion;
        OgnlContext context = (OgnlContext)Ognl.createDefaultContext(null);
        boolean isTrue = (Boolean)node.getAccessor().get(context, (Object)message);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("condtion-----" + condtion + "---" + isTrue));
        }
        return isTrue;
    }

    public static String getPlaceHolderActorId(ActorTransactionCfg cfg) {
        return (String)cfg.getGlobal().getParams().get("placeholderActorId");
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Result", "2");
        String tree = "Result!=1";
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("main(String[]) - " + Ognl.getValue((String)tree, map)));
        }
    }
}

