/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.sequence;

import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdWorker {
    private static final Log logger = LogFactory.getLog(IdWorker.class);
    private static final long TWEPOCH = 1288834974657L;
    private static final long WORKERIDBITS = 5L;
    private static final long DATACENTERIDBITS = 5L;
    private static final long MAXWORKERID = 31L;
    private static final long MAXDATACENTERID = 31L;
    private static final long SEQUENCEBITS = 12L;
    private static final long WORKERIDSHIFT = 12L;
    private static final long DATACENTERIDSHIFT = 17L;
    private static final long TIMESTAMPLEFTSHIFT = 22L;
    private static final long SEQUENCEMASK = 4095L;
    private static long lastTimestamp = -1L;
    private long sequence = 0L;
    private final long workerId;
    private final long datacenterId;
    private static IdWorker idWorker = new IdWorker();

    public IdWorker() {
        this.datacenterId = IdWorker.getDatacenterId(31L);
        this.workerId = IdWorker.getMaxWorkerId(this.datacenterId, 31L);
    }

    public static IdWorker getInstance() {
        return idWorker;
    }

    public IdWorker(long workerId, long datacenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (datacenterId > 31L || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
        }
        if (lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        lastTimestamp = timestamp;
        return timestamp - 1288834974657L << 22 | this.datacenterId << 17 | this.workerId << 12 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    protected static long getMaxWorkerId(long datacenterId, long MAXWORKERID) {
        StringBuffer mpid = new StringBuffer();
        mpid.append(datacenterId);
        String name = ManagementFactory.getRuntimeMXBean().getName();
        if (!name.isEmpty()) {
            mpid.append(name.split("@")[0]);
        }
        return (long)(mpid.toString().hashCode() & 0xFFFF) % (MAXWORKERID + 1L);
    }

    public long getDatacenterId() {
        return this.datacenterId;
    }

    public long getWorkerId() {
        return this.workerId;
    }

    protected static long getDatacenterId(long maxDatacenterId) {
        long id;
        block6: {
            id = 0L;
            try {
                Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
                byte[] mac = null;
                while (e.hasMoreElements()) {
                    NetworkInterface network = e.nextElement();
                    if (network != null) {
                        byte[] addres;
                        if (network.getHardwareAddress() == null || (addres = network.getHardwareAddress()) == null || addres.length <= 1) continue;
                        mac = addres;
                        break;
                    }
                    logger.info((Object)"\u83b7\u53d6MAC\u5730\u5740\u53d1\u751f\u5f02\u5e38");
                }
                if (mac == null) {
                    id = 1L;
                } else {
                    id = (0xFFL & (long)mac[mac.length - 1] | 0xFF00L & (long)mac[mac.length - 2] << 8) >> 6;
                    id %= maxDatacenterId + 1L;
                }
            }
            catch (Exception e) {
                logger.error((Object)"getDatacenterId(long)", (Throwable)e);
                if (!logger.isDebugEnabled()) break block6;
                logger.debug((Object)("getDatacenterId(long) -  getDatacenterId: " + e.getMessage()));
            }
        }
        return id;
    }
}

