/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.pattern;

import cn.ymotel.dactor.pattern.MatchPair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.DispatcherType;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PathMatcher;

public class PatternMatcher<T> {
    @Nullable
    private String[] includePatterns;
    @Nullable
    private String[] excludePatterns;
    @Nullable
    private PathMatcher pathMatcher = null;
    private Set<String> dispatcherTypeSet = new HashSet<String>();
    private Set<Integer> httpStatusSet = new HashSet<Integer>();
    private Set methods = new HashSet();
    private Set serverNames = new HashSet();
    private Set chains = new HashSet();
    private T bean;

    public PatternMatcher(@Nullable String[] includePatterns, @Nullable String[] excludePatterns, String[] chains, T bean) {
        this(includePatterns, excludePatterns, null, null, null, null, null, bean);
    }

    public PatternMatcher(@Nullable String[] includePatterns, @Nullable String[] excludePatterns, @Nullable String[] methods, @Nullable String[] serverNames, String[] dispatcherTypes, Integer[] httpStatus, String[] chains, T bean) {
        int i;
        this.includePatterns = this.filter(includePatterns);
        this.excludePatterns = this.filter(excludePatterns);
        if (dispatcherTypes != null) {
            for (i = 0; i < dispatcherTypes.length; ++i) {
                this.dispatcherTypeSet.add(dispatcherTypes[i]);
            }
        }
        if (this.dispatcherTypeSet.isEmpty()) {
            this.dispatcherTypeSet.add(DispatcherType.REQUEST.name());
        }
        if (httpStatus != null) {
            for (i = 0; i < httpStatus.length; ++i) {
                this.httpStatusSet.add(httpStatus[i]);
            }
        }
        this.bean = bean;
        if (methods != null) {
            for (i = 0; i < methods.length; ++i) {
                this.methods.add(methods[i]);
            }
        }
        if (serverNames != null) {
            for (i = 0; i < serverNames.length; ++i) {
                this.serverNames.add(serverNames[i]);
            }
        }
        if (chains != null) {
            for (i = 0; i < chains.length; ++i) {
                this.chains.add(chains[i]);
            }
        }
    }

    private String[] filter(String[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<String> ls = new ArrayList<String>();
        for (int i = 0; i < array.length; ++i) {
            String pattern = array[i];
            if (pattern == null || pattern.trim().equals("")) continue;
            ls.add(pattern.trim());
        }
        return ls.toArray(new String[0]);
    }

    public <T> T getBean() {
        return this.bean;
    }

    public void setPathMatcher(@Nullable PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public MatchPair matchePatterns(String lookupPath, PathMatcher pathMatcher) {
        return this.matchePatterns(lookupPath, pathMatcher, null, null, null, null, null, null);
    }

    private boolean isSetMatcher(Object key, Set set) {
        if (key == null) {
            return true;
        }
        if (set == null) {
            return true;
        }
        if (set.isEmpty()) {
            return true;
        }
        return set.contains(key);
    }

    public MatchPair matchePatterns(String lookupPath, PathMatcher pathMatcher, String method, String serverName, String dispatcherType, Integer httpStatus, String chain, Comparator comparator) {
        PathMatcher pathMatcherToUse;
        MatchPair<T> pair = new MatchPair<T>();
        if (this.isSetMatcher(serverName, this.serverNames)) {
            if (!this.serverNames.isEmpty()) {
                pair.setServerName(serverName);
            }
        } else {
            return null;
        }
        if (this.isSetMatcher(method, this.methods)) {
            if (!this.methods.isEmpty()) {
                pair.setMethod(method);
            }
        } else {
            return null;
        }
        if (this.isSetMatcher(dispatcherType, this.dispatcherTypeSet)) {
            if (!this.dispatcherTypeSet.isEmpty()) {
                pair.setDispatcherType(dispatcherType);
            }
        } else {
            return null;
        }
        if (this.isSetMatcher(httpStatus, this.httpStatusSet)) {
            if (!this.httpStatusSet.isEmpty()) {
                pair.setHttpStatus(httpStatus);
            }
        } else {
            return null;
        }
        if (this.isSetMatcher(chain, this.chains)) {
            if (!this.chains.isEmpty()) {
                pair.setChain(chain);
            }
        } else {
            return null;
        }
        PathMatcher pathMatcher2 = pathMatcherToUse = pathMatcher == null ? this.pathMatcher : pathMatcher;
        if (!ObjectUtils.isEmpty((Object[])this.excludePatterns)) {
            for (String pattern : this.excludePatterns) {
                if (!pathMatcherToUse.match(pattern, lookupPath)) continue;
                return null;
            }
        }
        if (!DispatcherType.ERROR.name().equals(dispatcherType)) {
            ArrayList<String> rtnList = new ArrayList<String>();
            if (this.includePatterns == null || this.includePatterns.length == 0) {
                return null;
            }
            for (String pattern : this.includePatterns) {
                if (!pathMatcherToUse.match(pattern, lookupPath)) continue;
                rtnList.add(pattern);
            }
            if (rtnList.isEmpty()) {
                return null;
            }
            if (comparator != null && rtnList.size() > 1) {
                rtnList.sort(comparator);
            }
            if (rtnList != null && rtnList.size() > 0) {
                pair.setMatchPattern((String)rtnList.get(0));
            }
            pair.setMatchPatterns(rtnList);
        }
        pair.setBean(this.bean);
        return pair;
    }
}

