/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.pattern;

import cn.ymotel.dactor.ActorUtils;
import cn.ymotel.dactor.pattern.MatchPair;
import cn.ymotel.dactor.pattern.PatternComparator;
import cn.ymotel.dactor.pattern.PatternMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class PatternLookUpMatch<T> {
    private PathMatcher pathMatcher = new AntPathMatcher();
    private List<PatternMatcher> patterns = new ArrayList<PatternMatcher>();

    public void add(PatternMatcher<T> matcher) {
        this.patterns.add(matcher);
    }

    public T lookupMatchBean(String UrlPath, String method, String serverName, String chain, HttpServletRequest request) {
        MatchPair pair = this.lookupMatchPair(UrlPath, method, serverName, chain, request);
        if (pair == null) {
            return null;
        }
        return pair.getBean();
    }

    public MatchPair lookupMatchPair(String UrlPath, String method, String serverName, String chain, HttpServletRequest request) {
        if (this.patterns.isEmpty()) {
            return null;
        }
        Comparator patterncomparator = this.pathMatcher.getPatternComparator(UrlPath);
        List<MatchPair> rtnList = Collections.synchronizedList(new ArrayList());
        this.patterns.forEach(matcher -> {
            MatchPair pair = matcher.matchePatterns(UrlPath, this.pathMatcher, method, serverName, request.getDispatcherType().name(), ActorUtils.getHttpErrorStatus(request), chain, patterncomparator);
            if (pair == null) {
                return;
            }
            rtnList.add(pair);
        });
        if (rtnList.size() == 0) {
            return null;
        }
        if (rtnList.size() == 1) {
            MatchPair pair = (MatchPair)rtnList.get(0);
            pair.setExtractMap(this.extractVariables(pair.getMatchPattern(), UrlPath));
            return pair;
        }
        PatternComparator comparator = new PatternComparator(patterncomparator);
        rtnList.sort(comparator);
        MatchPair pair = (MatchPair)rtnList.get(0);
        pair.setExtractMap(this.extractVariables(pair.getMatchPattern(), UrlPath));
        return pair;
    }

    public Map extractVariables(String MatchPattern, String urlPath) {
        if (MatchPattern == null) {
            return new HashMap();
        }
        Map map = this.pathMatcher.extractUriTemplateVariables(MatchPattern, urlPath);
        String path = this.pathMatcher.extractPathWithinPattern(MatchPattern, urlPath);
        map.put("_ExtractPath", path);
        return map;
    }
}

