/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.async.web.view;

import cn.ymotel.dactor.async.web.view.HttpView;
import cn.ymotel.dactor.message.ServletMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;

public class ZipView
implements HttpView<ServletMessage> {
    private String content = "_Content";

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public void render(ServletMessage message, String viewName) {
        if (!(message instanceof ServletMessage)) {
            return;
        }
        ServletMessage lMessage = message;
        if (lMessage.getAsyncContext().getResponse().isCommitted()) {
            return;
        }
        if (this.getContentType() != null) {
            lMessage.getAsyncContext().getResponse().setContentType(this.getContentType());
        }
        if (viewName != null && !viewName.equalsIgnoreCase("")) {
            ((HttpServletResponse)lMessage.getAsyncContext().getResponse()).setHeader("Content-Disposition", "attachment;filename=" + viewName);
        }
        Map content = (Map)message.getContextData(this.content);
        byte[] bs = this.getByte(content);
        try {
            lMessage.getAsyncContext().getResponse().getOutputStream().write(bs);
            lMessage.getAsyncContext().getResponse().getOutputStream().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            lMessage.getAsyncContext().complete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] WriteStream(InputStream input) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = input.read(buffer))) {
                byteArrayOutputStream.write(buffer, 0, n);
            }
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getByte(Map content) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
        for (Map.Entry entry : content.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            ZipEntry zipEntry = new ZipEntry(key);
            if (value instanceof byte[]) {
                try {
                    zipOutputStream.putNextEntry(zipEntry);
                    zipOutputStream.write((byte[])value);
                    zipOutputStream.flush();
                    zipOutputStream.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (value instanceof OutputStream) {
                byte[] bs = this.WriteStream((InputStream)value);
                try {
                    zipOutputStream.putNextEntry(zipEntry);
                    zipOutputStream.write(bs);
                    zipOutputStream.flush();
                    zipOutputStream.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!(value instanceof String)) continue;
            try {
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.write(((String)value).getBytes("UTF-8"));
                zipOutputStream.flush();
                zipOutputStream.closeEntry();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            zipOutputStream.flush();
            zipOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public String getContentType() {
        return "application/x-zip-compressed";
    }

    @Override
    public void setContentType(String contentType) {
    }
}

