/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.async.web;

import cn.ymotel.dactor.async.web.ContentTypeUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.MediaType;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.util.UrlPathHelper;

public class StaticResourceRequestHandler
implements HttpRequestHandler {
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private static final Log logger = LogFactory.getLog(StaticResourceRequestHandler.class);

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String UrlPath = this.urlPathHelper.getLookupPathForRequest(request);
        if (this.isInvalidPath(UrlPath)) {
            response.sendError(404);
            return;
        }
        ClassPathResource classPathResource = new ClassPathResource("/META-INF/resources" + UrlPath);
        byte[] out = null;
        try {
            out = StreamUtils.copyToByteArray((InputStream)classPathResource.getInputStream());
        }
        catch (IOException e) {
            response.sendError(404);
            return;
        }
        MediaType mediaType = ContentTypeUtil.getMediaType(request, UrlPath);
        if (mediaType != null) {
            response.setContentType(mediaType.toString());
        }
        response.getOutputStream().write(out);
        response.getOutputStream().flush();
    }

    protected boolean isInvalidPath(String path) {
        if (path.contains("WEB-INF") || path.contains("META-INF")) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Path with \"WEB-INF\" or \"META-INF\": [" + path + "]"));
            }
            return true;
        }
        if (path.contains(":/")) {
            String relativePath;
            String string = relativePath = path.charAt(0) == '/' ? path.substring(1) : path;
            if (ResourceUtils.isUrl((String)relativePath) || relativePath.startsWith("url:")) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Path represents URL or has \"url:\" prefix: [" + path + "]"));
                }
                return true;
            }
        }
        if (path.contains("..") && StringUtils.cleanPath((String)path).contains("../")) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Path contains \"../\" after call to StringUtils#cleanPath: [" + path + "]"));
            }
            return true;
        }
        return false;
    }
}

