/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.async.web;

import java.io.IOException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;

public class DActorAsyncListener
implements AsyncListener {
    private MultipartResolver multipartResolver;
    private static final Log logger = LogFactory.getLog(DActorAsyncListener.class);

    public DActorAsyncListener() {
    }

    public DActorAsyncListener(MultipartResolver multipartResolver) {
        this.multipartResolver = multipartResolver;
    }

    public void onComplete(AsyncEvent asyncEvent) throws IOException {
        this.clean((HttpServletRequest)asyncEvent.getAsyncContext().getRequest());
    }

    private void clean(HttpServletRequest processedRequest) {
        if (this.multipartResolver == null) {
            return;
        }
        if (processedRequest instanceof MultipartHttpServletRequest) {
            this.multipartResolver.cleanupMultipart((MultipartHttpServletRequest)processedRequest);
        }
    }

    public void onError(AsyncEvent asyncEvent) throws IOException {
        this.clean((HttpServletRequest)asyncEvent.getAsyncContext().getRequest());
        HttpServletResponse response = null;
        try {
            asyncEvent.getThrowable().printStackTrace();
            response = (HttpServletResponse)asyncEvent.getSuppliedResponse();
            response.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
    }

    public void onTimeout(AsyncEvent asyncEvent) throws IOException {
        this.clean((HttpServletRequest)asyncEvent.getAsyncContext().getRequest());
        HttpServletResponse response = (HttpServletResponse)asyncEvent.getSuppliedResponse();
        response.sendError(HttpStatus.REQUEST_TIMEOUT.value(), HttpStatus.REQUEST_TIMEOUT.getReasonPhrase());
    }
}

