/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.action.httpclient;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.nio.DefaultHttpClientIODispatch;
import org.apache.http.impl.nio.pool.BasicNIOConnPool;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.protocol.BasicAsyncRequestProducer;
import org.apache.http.nio.protocol.BasicAsyncResponseConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestExecutor;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncRequester;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.pool.ConnPool;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;

public class NHttpClient {
    private static final Log logger = LogFactory.getLog(NHttpClient.class);

    public static void main(String[] args) throws Exception {
        HttpProcessor httpproc = HttpProcessorBuilder.create().add((HttpRequestInterceptor)new RequestContent()).add((HttpRequestInterceptor)new RequestTargetHost()).add((HttpRequestInterceptor)new RequestConnControl()).add((HttpRequestInterceptor)new RequestUserAgent("Test/1.1")).add((HttpRequestInterceptor)new RequestExpectContinue(true)).build();
        HttpAsyncRequestExecutor protocolHandler = new HttpAsyncRequestExecutor();
        DefaultHttpClientIODispatch ioEventDispatch = new DefaultHttpClientIODispatch((NHttpClientEventHandler)protocolHandler, ConnectionConfig.DEFAULT);
        DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor();
        BasicNIOConnPool pool = new BasicNIOConnPool((ConnectingIOReactor)ioReactor, ConnectionConfig.DEFAULT);
        pool.setDefaultMaxPerRoute(2);
        pool.setMaxTotal(2);
        Thread t = new Thread(new Runnable((ConnectingIOReactor)ioReactor, (IOEventDispatch)ioEventDispatch){
            final /* synthetic */ ConnectingIOReactor val$ioReactor;
            final /* synthetic */ IOEventDispatch val$ioEventDispatch;
            {
                this.val$ioReactor = connectingIOReactor;
                this.val$ioEventDispatch = iOEventDispatch;
            }

            @Override
            public void run() {
                block5: {
                    try {
                        this.val$ioReactor.execute(this.val$ioEventDispatch);
                    }
                    catch (InterruptedIOException ex) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)"$Runnable.run() - Interrupted");
                        }
                    }
                    catch (IOException e) {
                        if (!logger.isTraceEnabled()) break block5;
                        logger.trace((Object)("$Runnable.run() - I/O error: " + e.getMessage()));
                    }
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"$Runnable.run() - Shutdown");
                }
            }
        });
        t.start();
        HttpAsyncRequester requester = new HttpAsyncRequester(httpproc);
        HttpHost[] targets = new HttpHost[]{new HttpHost("www.apache.org", 80, "http"), new HttpHost("www.verisign.com", 443, "https"), new HttpHost("www.google.com", 80, "http")};
        final CountDownLatch latch = new CountDownLatch(targets.length);
        for (final HttpHost target : targets) {
            BasicHttpRequest request = new BasicHttpRequest("GET", "/");
            HttpCoreContext coreContext = HttpCoreContext.create();
            requester.execute((HttpAsyncRequestProducer)new BasicAsyncRequestProducer(target, (HttpRequest)request), (HttpAsyncResponseConsumer)new BasicAsyncResponseConsumer(), (ConnPool)pool, (HttpContext)coreContext, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    latch.countDown();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("$FutureCallback<HttpResponse>.completed(HttpResponse) - " + target + "->" + response.getStatusLine()));
                    }
                }

                public void failed(Exception ex) {
                    latch.countDown();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("$FutureCallback<HttpResponse>.failed(Exception) - " + target + "->" + ex));
                    }
                }

                public void cancelled() {
                    latch.countDown();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("$FutureCallback<HttpResponse>.cancelled() - " + target + " cancelled"));
                    }
                }
            });
        }
        latch.await();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"main(String[]) - Shutting down I/O reactor");
        }
        ioReactor.shutdown();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"main(String[]) - Done");
        }
    }
}

