/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.action.httpclient;

import cn.ymotel.dactor.action.httpclient.IdleConnectionEvictor;
import cn.ymotel.dactor.action.httpclient.TrustAllHostnames;
import java.io.IOException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.cookie.DefaultCookieSpec;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.springframework.beans.factory.InitializingBean;

public class HttpClientHelper
implements InitializingBean {
    private static final Log logger = LogFactory.getLog(HttpClientHelper.class);
    private CloseableHttpAsyncClient httpclient;
    private int maxTotal = 100;
    private IdleConnectionEvictor connEvictor;

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public CloseableHttpAsyncClient getHttpclient() {
        return this.httpclient;
    }

    public void shutdown() {
        block2: {
            this.connEvictor.shutdown();
            try {
                this.httpclient.close();
            }
            catch (IOException e) {
                if (!logger.isTraceEnabled()) break block2;
                logger.trace((Object)"shutdown()");
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor();
        TrustAllHostnames hostnameVerifier = new TrustAllHostnames();
        SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
        Registry sessionStrategyRegistry = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)new SSLIOSessionStrategy(sslcontext, (HostnameVerifier)hostnameVerifier)).build();
        PoolingNHttpClientConnectionManager cm = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor, sessionStrategyRegistry);
        cm.setMaxTotal(this.maxTotal);
        cm.setDefaultMaxPerRoute(this.maxTotal);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("afterPropertiesSet() - " + cm.getDefaultConnectionConfig()));
        }
        class EasySpecProvider
        implements CookieSpecProvider {
            EasySpecProvider() {
            }

            public CookieSpec create(HttpContext context) {
                class EasyCookieSpec
                extends DefaultCookieSpec {
                    EasyCookieSpec() {
                    }

                    public void validate(Cookie arg0, CookieOrigin arg1) throws MalformedCookieException {
                    }
                }
                return new EasyCookieSpec();
            }
        }
        Registry r = RegistryBuilder.create().register("easy", (Object)new EasySpecProvider()).build();
        BasicCookieStore cookieStore = new BasicCookieStore();
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("easy").build();
        HttpAsyncClientBuilder builder = HttpAsyncClients.custom().setDefaultCookieStore((CookieStore)cookieStore).setDefaultCookieSpecRegistry((Lookup)r).setDefaultRequestConfig(requestConfig).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setConnectionManager((NHttpClientConnectionManager)cm).setSSLStrategy((SchemeIOSessionStrategy)SSLIOSessionStrategy.getDefaultStrategy());
        this.httpclient = builder.build();
        this.httpclient.start();
        this.connEvictor = new IdleConnectionEvictor((NHttpClientConnectionManager)cm);
        this.connEvictor.start();
    }
}

