/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.action.httpclient;

import cn.ymotel.dactor.action.Actor;
import cn.ymotel.dactor.action.httpclient.ActorHttpClientResponse;
import cn.ymotel.dactor.action.httpclient.HttpClientHelper;
import cn.ymotel.dactor.message.Message;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.protocol.HttpContext;

public class HttpClientActor
implements Actor {
    private static final Log logger = LogFactory.getLog(HttpClientActor.class);
    private HttpClientHelper httpClientHelper;
    public static String URL = "_HttpClient_URL";
    public static String CHARSET = "_HTTPCLIENT_CHARSET";
    public static String PARAMS = "_HTTPCLIENT_PARAMS";
    public static String METHOD = "_HTTPCLIENT_METHOD";
    public static String RESPONSE = "_HTTPCLIENT_RESPONSE";
    public static String HTTPCLIENT_CONTEXT = "_HTTP_CLIENT_CONTEXT";
    public static String CONTENT = "_HTTPCLIENT_CONTENT";
    private ActorHttpClientResponse actorHttpClientResponse;
    private String url = null;
    private String method = null;
    private String charset = null;
    private String referer = null;
    private String content = null;
    private Map paramsMapping = new HashMap();
    private Map paramsDefaultValue = new HashMap();

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getReferer() {
        return this.referer;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public Map getParamsDefaultValue() {
        return this.paramsDefaultValue;
    }

    public void setParamsDefaultValue(Map paramsDefaultValue) {
        this.paramsDefaultValue = paramsDefaultValue;
    }

    public Map getParamsMapping() {
        return this.paramsMapping;
    }

    public void setParamsMapping(Map paramsMapping) {
        this.paramsMapping = paramsMapping;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public HttpClientHelper getHttpClientHelper() {
        return this.httpClientHelper;
    }

    public void setHttpClientHelper(HttpClientHelper httpClientHelper) {
        this.httpClientHelper = httpClientHelper;
    }

    public ActorHttpClientResponse getActorHttpClientResponse() {
        return this.actorHttpClientResponse;
    }

    public void setActorHttpClientResponse(ActorHttpClientResponse actorHttpClientResponse) {
        this.actorHttpClientResponse = actorHttpClientResponse;
    }

    public Object HandleMessage(final Message message) throws Exception {
        Map context = message.getContext();
        HttpUriRequest request = this.getHttpBuild(message.getContext()).build();
        if (this.referer != null) {
            request.addHeader("Referer", this.referer);
        }
        HttpClientContext tmplocalContext = null;
        if (context.containsKey(HTTPCLIENT_CONTEXT)) {
            tmplocalContext = (HttpClientContext)context.get(HTTPCLIENT_CONTEXT);
        } else {
            tmplocalContext = HttpClientContext.create();
            BasicCookieStore cookieStore = new BasicCookieStore();
            tmplocalContext.setCookieStore((CookieStore)cookieStore);
            context.put(HTTPCLIENT_CONTEXT, tmplocalContext);
        }
        final HttpClientContext localContext = tmplocalContext;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("HandleMessage(Message) - httpclient----" + request));
        }
        final String tmpcontent = this.content;
        final String tmpcharset = this.charset != null ? this.charset : (String)context.get(CHARSET);
        this.httpClientHelper.getHttpclient().execute(request, (HttpContext)localContext, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse response) {
                try {
                    message.getContext().remove(tmpcontent);
                    HttpClientActor.this.actorHttpClientResponse.handleResponse(response, localContext, tmpcharset, message);
                }
                catch (Exception e) {
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)"$FutureCallback<HttpResponse>.completed(HttpResponse)", (Throwable)e);
                    }
                    message.setException(e);
                    message.getControlMessage().getMessageDispatcher().sendMessage(message);
                }
            }

            public void failed(Exception ex) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"$FutureCallback<HttpResponse>.failed(Exception)", (Throwable)ex);
                }
                message.setException(ex);
                message.getControlMessage().getMessageDispatcher().sendMessage(message);
            }

            public void cancelled() {
                Exception exception = new Exception("\u5df2\u53d6\u6d88");
                message.setException(exception);
                message.getControlMessage().getMessageDispatcher().sendMessage(message);
            }
        });
        return null;
    }

    public Map getMap(Map context) {
        if (context.containsKey(PARAMS)) {
            return (Map)context.get(PARAMS);
        }
        HashMap map = new HashMap();
        for (Map.Entry entry : this.paramsMapping.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null || value.trim().equals("")) {
                map.put(key, context.get(key));
                continue;
            }
            map.put(key, context.get(value));
        }
        for (Map.Entry entry : this.paramsDefaultValue.entrySet()) {
            if (map.containsKey(entry.getKey())) continue;
            map.put((String)entry.getKey(), entry.getValue());
        }
        return map;
    }

    public HttpGet getHttpGet(Map context) {
        String tmpUrl = null;
        tmpUrl = this.url != null ? this.url : (String)context.get(URL);
        HttpGet httpget = new HttpGet(tmpUrl);
        return httpget;
    }

    public RequestBuilder getHttpBuild(Map context) throws UnsupportedEncodingException {
        Object obcontent;
        String Method = (String)context.get(METHOD);
        RequestBuilder builder = null;
        if (Method == null) {
            Method = this.method;
        }
        if (Method == null) {
            Method = "GET";
        }
        if (Method.equals("GET")) {
            builder = RequestBuilder.get();
        } else if (Method.equals("POST")) {
            builder = RequestBuilder.post();
        }
        if (this.content != null && (obcontent = context.get(this.content)) != null) {
            if (obcontent instanceof String) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("HandleMessage(Message) - content----" + obcontent));
                }
                builder.setEntity((HttpEntity)new StringEntity((String)obcontent));
            } else if (obcontent instanceof byte[]) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("HandleMessage(Message) - content----" + new String((byte[])obcontent)));
                }
                builder.setEntity((HttpEntity)new ByteArrayEntity((byte[])obcontent));
            }
        }
        String tmpcharset = this.charset != null ? this.charset : (String)context.get(CHARSET);
        builder.setCharset(Charset.forName(tmpcharset));
        String tmpUrl = null;
        tmpUrl = this.url != null ? this.url : (String)context.get(URL);
        builder.setUri(tmpUrl);
        Map map = this.getMap(context);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("getHttpBuild(Map, RequestBuilder) - " + map));
        }
        for (Map.Entry entry : map.entrySet()) {
            builder.addParameter((String)entry.getKey(), (String)entry.getValue());
        }
        return builder;
    }

    public static String getContentCharSet(byte[] bytes) throws ParseException {
        String charSet = "";
        String regEx = "(?=<meta).*?(?<=charset=[\\'|\\\"]?)([[a-z]|[A-Z]|[0-9]|-]*)";
        Pattern p = Pattern.compile(regEx, 2);
        Matcher m = p.matcher(new String(bytes));
        boolean result = m.find();
        if (!result) {
            return "gbk";
        }
        if (m.groupCount() == 1) {
            charSet = m.group(1);
        }
        if (charSet.trim().equals("")) {
            charSet = "gbk";
        }
        return charSet;
    }
}

