/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.action.httpclient;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicResponseHandlerExt
implements ResponseHandler<String> {
    private static final Log logger = LogFactory.getLog(BasicResponseHandlerExt.class);
    private String charset = null;

    public BasicResponseHandlerExt() {
    }

    public BasicResponseHandlerExt(String scharset) {
        if (scharset != null) {
            this.charset = scharset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String handleResponse(HttpResponse response) throws HttpResponseException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        try {
            if (statusLine.getStatusCode() >= 300) {
                EntityUtils.consume((HttpEntity)entity);
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            if (entity == null) {
                String string = null;
                return string;
            }
            Charset charset1 = null;
            if (this.charset != null) {
                charset1 = Charset.forName(this.charset);
            } else {
                ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
                charset1 = contentType.getCharset();
                if (charset1 == null || "".equals(charset1.toString())) {
                    byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity);
                    charset1 = Charset.forName(BasicResponseHandlerExt.getContentCharSet(bytes));
                    String string = new String(bytes, charset1);
                    return string;
                }
                if (charset1 == null || "".equals(charset1.toString())) {
                    charset1 = Charset.forName(this.charset);
                }
            }
            String string = EntityUtils.toString((HttpEntity)entity, (Charset)charset1);
            return string;
        }
        catch (ParseException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"handleResponse(HttpResponse)", (Throwable)e);
            }
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)entity);
        }
        return "";
    }

    public static String getContentCharSet(byte[] bytes) throws ParseException {
        String charSet = "";
        String regEx = "(?=<meta).*?(?<=charset=[\\'|\\\"]?)([[a-z]|[A-Z]|[0-9]|-]*)";
        Pattern p = Pattern.compile(regEx, 2);
        Matcher m = p.matcher(new String(bytes));
        boolean result = m.find();
        if (!result) {
            return "gbk";
        }
        if (m.groupCount() == 1) {
            charSet = m.group(1);
        }
        if (charSet.trim().equals("")) {
            charSet = "gbk";
        }
        return charSet;
    }
}

