/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.spring.annotaion;

import cn.ymotel.dactor.core.ActorTransactionCfg;
import cn.ymotel.dactor.spring.annotaion.ActorCfg;
import java.util.HashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultBeanNameGenerator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public class ActorCfgBeanFactoryPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    private BeanDefinitionRegistry registry;
    private BeanNameGenerator beanNameGenerator = new DefaultBeanNameGenerator();

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] beans;
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)beanFactory;
        for (String s : beans = beanFactory.getBeanDefinitionNames()) {
            Class beanType = beanFactory.getType(s);
            ActorCfg actorCfg = (ActorCfg)AnnotationUtils.findAnnotation((Class)beanType, ActorCfg.class);
            if (actorCfg == null) continue;
            RootBeanDefinition rootBeanDefinition = new RootBeanDefinition();
            rootBeanDefinition.setBeanClass(ActorTransactionCfg.class);
            String name = this.beanNameGenerator.generateBeanName((BeanDefinition)rootBeanDefinition, this.registry);
            this.beanBuilder(actorCfg, s, name, defaultListableBeanFactory);
        }
    }

    public void beanBuilder(ActorCfg actorCfg, String beanid, String name, DefaultListableBeanFactory defaultListableBeanFactory) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ActorTransactionCfg.class);
        builder.addPropertyValue("beginBeanId", (Object)beanid);
        if (actorCfg.urlPatterns() != null && actorCfg.urlPatterns().length != 0) {
            builder.addPropertyValue("urlPattern", (Object)actorCfg.urlPatterns());
        }
        if (actorCfg.methods() != null && actorCfg.methods().length != 0) {
            String[] methods = new String[actorCfg.methods().length];
            for (int i = 0; i < actorCfg.methods().length; ++i) {
                methods[i] = actorCfg.methods()[i].name();
            }
            builder.addPropertyValue("methods", (Object)methods);
        }
        if (actorCfg.excludeUrlPatterns() != null && actorCfg.excludeUrlPatterns().length != 0) {
            builder.addPropertyValue("excludeUrlPattern", (Object)actorCfg.excludeUrlPatterns());
        }
        if (StringUtils.hasText((String)actorCfg.chain())) {
            builder.addPropertyReference("chain", actorCfg.chain());
        }
        if (StringUtils.hasText((String)actorCfg.parent())) {
            builder.addPropertyReference("parent", actorCfg.parent());
        }
        if (StringUtils.hasText((String)actorCfg.view())) {
            HashMap<String, String> viewmap = new HashMap<String, String>();
            viewmap.put("success", actorCfg.view());
            builder.addPropertyValue("results", viewmap);
        }
        String cfgid = null;
        cfgid = actorCfg.id() == null || actorCfg.id().equals("") ? name : actorCfg.id();
        builder.addPropertyValue("domains", (Object)actorCfg.domains());
        builder.addPropertyValue("id", (Object)cfgid);
        if (actorCfg.timeout() > 0L) {
            builder.addPropertyValue("timeout", (Object)actorCfg.timeout());
        }
        ManagedList urlPatternList = new ManagedList();
        if (actorCfg.urlPatternClass() == null || actorCfg.urlPatternClass().length == 0) {
            urlPatternList.add(new RuntimeBeanReference(beanid));
        } else {
            for (int i = 0; i < actorCfg.urlPatternClass().length; ++i) {
                BeanDefinitionBuilder UrlPatternbuilder = BeanDefinitionBuilder.rootBeanDefinition(actorCfg.urlPatternClass()[i]);
                String UrlPatternname = this.beanNameGenerator.generateBeanName((BeanDefinition)UrlPatternbuilder.getRawBeanDefinition(), this.registry);
                defaultListableBeanFactory.registerBeanDefinition(UrlPatternname, (BeanDefinition)UrlPatternbuilder.getRawBeanDefinition());
                urlPatternList.add(new RuntimeBeanReference(UrlPatternname));
            }
        }
        builder.addPropertyValue("dyanmicUrlPatterns", (Object)urlPatternList);
        builder.setLazyInit(false);
        defaultListableBeanFactory.registerBeanDefinition(cfgid, (BeanDefinition)builder.getRawBeanDefinition());
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.registry = registry;
    }
}

