/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.response;

import cn.ymotel.dactor.Constants;
import cn.ymotel.dactor.action.Actor;
import cn.ymotel.dactor.action.netty.aysnsocket.TcpServerActor;
import cn.ymotel.dactor.action.netty.httpserver.HttpServerResponseActor;
import cn.ymotel.dactor.message.Message;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class TransportResponseViewActor
implements Actor,
Constants,
ApplicationContextAware {
    private Map<String, Object> transportMap = new HashMap<String, Object>();
    private Actor defaultViewActor = null;
    private ApplicationContext applicationContext;

    public TransportResponseViewActor() {
        this.transportMap.put("netty_tcp", new TcpServerActor());
        this.transportMap.put("netty_http", new HttpServerResponseActor());
    }

    public Map<String, Object> getTransportMap() {
        return this.transportMap;
    }

    public void setTransportMap(Map transportMap) {
        this.transportMap = transportMap;
    }

    public void setDefaultViewActor(Actor defaultViewActor) {
        this.defaultViewActor = defaultViewActor;
    }

    public Object HandleMessage(Message message) throws Throwable {
        String transport = (String)message.getControlData().get("transport");
        if (transport == null) {
            if (this.defaultViewActor != null) {
                return this.defaultViewActor.HandleMessage(message);
            }
            System.err.println("Can't find transport");
            return message;
        }
        Object obj = this.transportMap.get(transport);
        if (obj instanceof String) {
            Actor actor = (Actor)this.applicationContext.getBean((String)obj);
            return actor.HandleMessage(message);
        }
        if (obj instanceof Actor) {
            return ((Actor)obj).HandleMessage(message);
        }
        return null;
    }

    private void addMapping(String transport, String beanId) {
        this.transportMap.put(transport, beanId);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

