/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.pattern;

import cn.ymotel.dactor.pattern.MatchPair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PathMatcher;

public class PatternMatcher<T> {
    @Nullable
    private String[] includePatterns;
    @Nullable
    private String[] excludePatterns;
    @Nullable
    private PathMatcher pathMatcher = null;
    private Set methods = new HashSet();
    private Set serverNames = new HashSet();
    private T bean;

    public PatternMatcher(@Nullable String[] includePatterns, @Nullable String[] excludePatterns, T bean) {
        this.includePatterns = this.filter(includePatterns);
        this.excludePatterns = this.filter(excludePatterns);
        this.bean = bean;
    }

    public PatternMatcher(@Nullable List includePatterns, @Nullable List excludePatterns, T bean) {
        this.includePatterns = includePatterns.toArray(new String[0]);
        this.excludePatterns = excludePatterns.toArray(new String[0]);
        this.bean = bean;
    }

    public PatternMatcher(@Nullable String[] includePatterns, @Nullable String[] excludePatterns, @Nullable String[] methods, @Nullable String[] serverNames, T bean) {
        int i;
        this.includePatterns = this.filter(includePatterns);
        this.excludePatterns = this.filter(excludePatterns);
        this.bean = bean;
        if (methods != null) {
            for (i = 0; i < methods.length; ++i) {
                this.methods.add(methods[i]);
            }
        }
        if (serverNames != null) {
            for (i = 0; i < serverNames.length; ++i) {
                this.serverNames.add(serverNames[i]);
            }
        }
    }

    public PatternMatcher(@Nullable List includePatterns, @Nullable List excludePatterns, List methods, List serverNames, T bean) {
        int i;
        this.includePatterns = this.filter(includePatterns.toArray(new String[0]));
        this.excludePatterns = this.filter(excludePatterns.toArray(new String[0]));
        this.bean = bean;
        if (methods != null) {
            for (i = 0; i < methods.size(); ++i) {
                this.methods.add(methods.get(i));
            }
        }
        if (serverNames != null) {
            for (i = 0; i < serverNames.size(); ++i) {
                this.serverNames.add(serverNames.get(i));
            }
        }
    }

    private String[] filter(String[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<String> ls = new ArrayList<String>();
        for (int i = 0; i < array.length; ++i) {
            String pattern = array[i];
            if (pattern == null || pattern.trim().equals("")) continue;
            ls.add(pattern.trim());
        }
        return ls.toArray(new String[0]);
    }

    public <T> T getBean() {
        return this.bean;
    }

    public void setPathMatcher(@Nullable PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public MatchPair matchePatterns(String lookupPath, PathMatcher pathMatcher) {
        return this.matchePatterns(lookupPath, pathMatcher, null, null, null);
    }

    public MatchPair matchePatterns(String lookupPath, PathMatcher pathMatcher, String method, String serverName, Comparator comparator) {
        PathMatcher pathMatcherToUse;
        if (serverName != null && !this.serverNames.isEmpty() && !this.serverNames.contains(serverName)) {
            return null;
        }
        if (method != null && !this.methods.isEmpty() && !this.methods.contains(method)) {
            return null;
        }
        PathMatcher pathMatcher2 = pathMatcherToUse = pathMatcher == null ? this.pathMatcher : pathMatcher;
        if (!ObjectUtils.isEmpty((Object[])this.excludePatterns)) {
            for (String pattern : this.excludePatterns) {
                if (!pathMatcherToUse.match(pattern, lookupPath)) continue;
                return null;
            }
        }
        if (ObjectUtils.isEmpty((Object[])this.includePatterns)) {
            return null;
        }
        MatchPair<T> pair = new MatchPair<T>();
        ArrayList<String> rtnList = new ArrayList<String>();
        for (String pattern : this.includePatterns) {
            if (!pathMatcherToUse.match(pattern, lookupPath)) continue;
            rtnList.add(pattern);
        }
        if (rtnList.isEmpty()) {
            return null;
        }
        if (!this.methods.isEmpty()) {
            pair.setMethod(method);
        }
        if (!this.serverNames.isEmpty()) {
            pair.setServerName(serverName);
        }
        pair.setBean(this.bean);
        if (comparator != null && rtnList.size() > 1) {
            rtnList.sort(comparator);
        }
        pair.setMatchPattern((String)rtnList.get(0));
        pair.setMatchPatterns(rtnList);
        return pair;
    }
}

