/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.message;

import cn.ymotel.dactor.ActorUtils;
import cn.ymotel.dactor.message.DefaultMessage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class ServletMessage
extends DefaultMessage {
    private AsyncContext AsyncContext;
    private HttpServletRequest request;
    private HttpServletResponse response;

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public AsyncContext getAsyncContext() {
        return this.AsyncContext;
    }

    public void setAsyncContext(AsyncContext asyncContext) {
        this.AsyncContext = asyncContext;
    }

    @Override
    public <T> T getUser() {
        return (T)this.request.getSession(true).getAttribute("_USER");
    }

    @Override
    public void setUser(Object user) {
        this.request.getSession(true).setAttribute("_USER", user);
    }

    public byte[] getFileBytes(String fileName) throws IOException {
        MultipartFile file = ((MultipartHttpServletRequest)this.AsyncContext.getRequest()).getFile(fileName);
        return file.getBytes();
    }

    public String getFileString(String fileName, String charset) throws IOException {
        return new String(this.getFileBytes(fileName), charset);
    }

    public String getFileString(String fileName, Charset charset) throws IOException {
        return new String(this.getFileBytes(fileName), charset);
    }

    public List getFileNames() {
        ArrayList ls = new ArrayList();
        Iterator iterator = ((MultipartHttpServletRequest)this.AsyncContext.getRequest()).getFileNames();
        while (iterator.hasNext()) {
            ls.add(iterator.next());
        }
        return ls;
    }

    public List<MultipartFile> getFiles(String name) {
        return ((MultipartHttpServletRequest)this.AsyncContext.getRequest()).getFiles(name);
    }

    public MultipartFile getFile(String name) {
        return ((MultipartHttpServletRequest)this.AsyncContext.getRequest()).getFile(name);
    }

    public InputStream getFileStream(String fileName) throws IOException {
        MultipartFile file = ((MultipartHttpServletRequest)this.AsyncContext.getRequest()).getFile(fileName);
        return file.getInputStream();
    }

    public String getClientIp() {
        return ActorUtils.getClientIP((HttpServletRequest)this.AsyncContext.getRequest());
    }

    public String getHeaderIgnoreCase(String nameIgnoreCase) {
        HttpServletRequest request = (HttpServletRequest)this.AsyncContext.getRequest();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name == null || !name.equalsIgnoreCase(nameIgnoreCase)) continue;
            return request.getHeader(name);
        }
        return null;
    }

    public String getHeader(String name) {
        HttpServletRequest request = (HttpServletRequest)this.AsyncContext.getRequest();
        return request.getHeader(name);
    }
}

