/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.async.web.view;

import cn.ymotel.dactor.async.web.view.JsonUtil;
import cn.ymotel.dactor.async.web.view.StreamView;
import cn.ymotel.dactor.message.ServletMessage;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonView
extends StreamView {
    private static final Log logger = LogFactory.getLog(JsonView.class);
    private String content = "_Content";
    private static SerializeConfig mapping = new SerializeConfig();

    public JsonView() {
        this.urlSuffix = "json";
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public void renderInner(ServletMessage message, String viewName) {
        block12: {
            Object jsonObject = message.getContext().get(this.content);
            if (jsonObject == null) {
                try {
                    message.getAsyncContext().getResponse().getWriter().print("");
                    message.getAsyncContext().getResponse().getWriter().flush();
                    message.getAsyncContext().complete();
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            jsonObject = JsonUtil.AppendHead(message, jsonObject);
            String jsonString = null;
            if (jsonObject instanceof String) {
                jsonString = (String)jsonObject;
            } else if (jsonObject instanceof byte[]) {
                try {
                    jsonString = new String((byte[])jsonObject, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"", (Throwable)e);
                    }
                }
            } else {
                jsonString = JSON.toJSONString(jsonObject, (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[0]);
            }
            try {
                message.getAsyncContext().getResponse().getWriter().print(jsonString);
                message.getAsyncContext().getResponse().getWriter().flush();
                message.getAsyncContext().complete();
            }
            catch (IOException e) {
                if (!logger.isTraceEnabled()) break block12;
                logger.trace((Object)"renderInner(LocalServletMessage, String)");
            }
        }
    }

    static {
        mapping.put(Long.class, JsonUtil.longSerializer);
    }
}

