/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.async.web;

import cn.ymotel.dactor.ActorUtils;
import cn.ymotel.dactor.async.web.DActorAsyncListener;
import cn.ymotel.dactor.core.ActorTransactionCfg;
import cn.ymotel.dactor.core.MessageDispatcher;
import cn.ymotel.dactor.core.UrlMapping;
import cn.ymotel.dactor.message.DefaultResolveMessage;
import cn.ymotel.dactor.message.Message;
import cn.ymotel.dactor.pattern.MatchPair;
import cn.ymotel.dactor.pattern.PatternLookUpMatch;
import cn.ymotel.dactor.pattern.PatternMatcher;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;
import org.springframework.web.util.UrlPathHelper;

public class AsyncServletFilter
implements Filter {
    private static final Log logger = LogFactory.getLog(AsyncServletFilter.class);
    private WebApplicationContext applicationContext;
    private final MultipartResolver defaultMultipartResolver = new StandardServletMultipartResolver();
    private ServletContext servletContext;
    public static final String DEFAULT_MULTIPART_RESOLVER_BEAN_NAME = "filterMultipartResolver";
    private String multipartResolverBeanName = "filterMultipartResolver";
    private long timeout = 30000L;
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private DefaultResolveMessage defaultResolveMessage = null;
    public static String messageSourceId = "messageSource";
    private int errorcode = HttpStatus.TOO_MANY_REQUESTS.value();
    private HttpStatus errstatus = HttpStatus.TOO_MANY_REQUESTS;
    private AntPathMatcher antPathMatcher = new AntPathMatcher();
    private static final String DISPATCHER = WebApplicationContext.class.getName() + ".dispatchers";

    public WebApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(WebApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setMultipartResolverBeanName(String multipartResolverBeanName) {
        this.multipartResolverBeanName = multipartResolverBeanName;
    }

    protected String getMultipartResolverBeanName() {
        return this.multipartResolverBeanName;
    }

    protected ServletContext getServletContext() {
        if (this.servletContext != null) {
            return this.servletContext;
        }
        throw new IllegalStateException("No ServletContext");
    }

    protected MultipartResolver lookupMultipartResolver() {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        String beanName = this.getMultipartResolverBeanName();
        if (wac != null && wac.containsBean(beanName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using MultipartResolver '" + beanName + "' for MultipartFilter"));
            }
            return (MultipartResolver)wac.getBean(beanName, MultipartResolver.class);
        }
        return this.defaultMultipartResolver;
    }

    public UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.init(filterConfig.getServletContext(), filterConfig.getInitParameter("errcode"));
        this.antPathMatcher.setCaseSensitive(false);
    }

    public void init(ServletContext servletContext, String errcode) {
        this.setApplicationContext(WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext));
        String serrcode = errcode;
        if (serrcode != null && !serrcode.trim().equals("")) {
            try {
                this.errorcode = Integer.parseInt(serrcode);
                this.errstatus = HttpStatus.resolve((int)this.errorcode);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        this.urlPathHelper.setAlwaysUseFullPath(true);
        this.defaultResolveMessage = (DefaultResolveMessage)ActorUtils.getCacheBean((ApplicationContext)this.getApplicationContext(), "DefaultResolveMessage");
        if (this.defaultResolveMessage == null) {
            this.defaultResolveMessage = new DefaultResolveMessage();
        }
        this.servletContext = servletContext;
    }

    public void doFilter(ServletRequest request1, ServletResponse response1, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)request1;
        HttpServletResponse response = (HttpServletResponse)response1;
        if (!this.doService(request, response)) {
            chain.doFilter(request1, response1);
        }
    }

    public boolean doService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String UrlPath = this.urlPathHelper.getLookupPathForRequest(request);
        Object requestHandler = this.getRequestHandler(request, UrlPath);
        if (requestHandler == null) {
            return false;
        }
        if (requestHandler instanceof HttpRequestHandler) {
            ((HttpRequestHandler)requestHandler).handleRequest(request, response);
            return true;
        }
        if (requestHandler instanceof ActorTransactionCfg) {
            ActorTransactionCfg cfg = (ActorTransactionCfg)requestHandler;
            this.HandleAsyncContext(request, response, cfg, UrlPath, null);
            return true;
        }
        if (requestHandler instanceof MatchPair) {
            MatchPair pair = (MatchPair)requestHandler;
            if (pair.getBean() instanceof HttpRequestHandler) {
                ((HttpRequestHandler)pair.getBean()).handleRequest(request, response);
                return true;
            }
            if (pair.getBean() instanceof ActorTransactionCfg) {
                ActorTransactionCfg cfg = (ActorTransactionCfg)((MatchPair)requestHandler).getBean();
                this.HandleAsyncContext(request, response, cfg, UrlPath, ((MatchPair)requestHandler).getExtractMap());
                return true;
            }
        }
        return false;
    }

    public void HandleAsyncContext(HttpServletRequest request, HttpServletResponse response, ActorTransactionCfg cfg, String UrlPath, Map extractMap) throws IOException {
        MultipartResolver multipartResolver = this.lookupMultipartResolver();
        if (multipartResolver.isMultipart(request)) {
            request = multipartResolver.resolveMultipart(request);
        }
        String suffix = null;
        if (UrlPath.lastIndexOf(".") >= 0) {
            suffix = UrlPath.substring(UrlPath.lastIndexOf(".") + 1);
        }
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.addListener((AsyncListener)new DActorAsyncListener(multipartResolver));
        if (cfg.getTimeout() > 0L) {
            asyncContext.setTimeout(cfg.getTimeout());
        } else {
            asyncContext.setTimeout(this.timeout);
        }
        Message message = this.defaultResolveMessage.resolveContext(asyncContext, request, response);
        message.getContext().putAll(extractMap);
        message.getControlData().putAll(extractMap);
        message.getContext().put("_METHOD", request.getMethod());
        message.getContext().put("_SUFFIX", suffix);
        this.addTransPort(message);
        try {
            boolean b = this.getDispatcher(request.getServletContext()).startMessage(message, cfg, false);
            if (!b) {
                if (this.errstatus != null) {
                    ((HttpServletResponse)asyncContext.getResponse()).sendError(this.errstatus.value(), this.errstatus.getReasonPhrase());
                } else {
                    ((HttpServletResponse)asyncContext.getResponse()).sendError(this.errorcode);
                }
                return;
            }
        }
        catch (Exception e) {
            asyncContext.getResponse().setContentType("text/html; charset=utf-8");
            asyncContext.getRequest().setAttribute("_EXCEPTION", (Object)e);
            asyncContext.getResponse().getWriter().print(e.getMessage());
            asyncContext.getResponse().getWriter().flush();
            asyncContext.complete();
        }
    }

    protected void addTransPort(Message message) {
        message.getControlData().put("transport", "http_servlet");
    }

    public Object getRequestHandler(HttpServletRequest request, String UrlPath) {
        Object bean;
        String transactionId = this.resolveTransactionId(UrlPath, request);
        transactionId = ActorUtils.getBeanFromTranstionId((ApplicationContext)this.getApplicationContext(), transactionId);
        if (transactionId != null && (bean = ActorUtils.getCacheBean((ApplicationContext)this.getApplicationContext(), transactionId)) instanceof ActorTransactionCfg && this.matchDomain((ActorTransactionCfg)bean, request.getServerName())) {
            return bean;
        }
        return this.UrlPatternHandler(UrlPath, request);
    }

    private MatchPair UrlPatternHandler(String UrlPath, HttpServletRequest request) {
        PatternLookUpMatch lookUpMatch = new PatternLookUpMatch();
        Map<PatternMatcher, ActorTransactionCfg> patternMap = UrlMapping.getPatternMapping();
        patternMap.forEach((matcher, cfg) -> lookUpMatch.add(matcher));
        Map mapping = UrlMapping.getMapping();
        mapping.forEach((key, value) -> {
            PatternMatcher<Object> patternMatcher = new PatternMatcher<Object>(new String[]{key}, null, value);
            lookUpMatch.add(patternMatcher);
        });
        UrlMapping.getDynamicMapping().forEach((dyanmicUrlPattern, actorTransactionCfg) -> {
            String[] patterns = dyanmicUrlPattern.getPatterns(request);
            PatternMatcher<ActorTransactionCfg> patternMatcher = new PatternMatcher<ActorTransactionCfg>(patterns, dyanmicUrlPattern.getExcludePatterns(request), (ActorTransactionCfg)actorTransactionCfg);
            lookUpMatch.add(patternMatcher);
        });
        MatchPair matchPair = lookUpMatch.lookupMatchPair(UrlPath, request.getMethod(), request.getServerName());
        return matchPair;
    }

    private boolean matchDomain(ActorTransactionCfg cfg, String serverName) {
        if (cfg.getDomains() == null) {
            return true;
        }
        String[] domains = cfg.getDomains();
        for (int i = 0; i < domains.length; ++i) {
            if (!domains[i].equals(serverName)) continue;
            return true;
        }
        return false;
    }

    public Map getUrlmap(String urlPath, ActorTransactionCfg cfg, String matternPattern) {
        if (matternPattern != null) {
            return this.antPathMatcher.extractUriTemplateVariables(matternPattern, urlPath);
        }
        if (cfg.getUrlPattern() == null || cfg.getUrlPattern().length == 0) {
            return new HashMap();
        }
        String[] pattern = cfg.getUrlPattern();
        for (int i = 0; i < pattern.length; ++i) {
            if (!this.antPathMatcher.match(pattern[i], urlPath)) continue;
            return this.antPathMatcher.extractUriTemplateVariables(pattern[i], urlPath);
        }
        return new HashMap();
    }

    protected String resolveTransactionId(String path, HttpServletRequest request) {
        if (path == null || path.equals("/")) {
            return null;
        }
        int lastindex = path.lastIndexOf(".");
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (lastindex >= 0) {
            return path.substring(0, path.lastIndexOf(".")).replaceAll("/", ".");
        }
        return path.replaceAll("/", ".");
    }

    public MessageDispatcher getDispatcher(ServletContext sc) {
        MessageDispatcher dispatcher;
        block1: {
            if (sc.getAttribute(DISPATCHER) != null) {
                return (MessageDispatcher)sc.getAttribute(DISPATCHER);
            }
            Map dispatcherMap = this.getApplicationContext().getBeansOfType(MessageDispatcher.class);
            dispatcher = null;
            Iterator iter = dispatcherMap.entrySet().iterator();
            if (!iter.hasNext()) break block1;
            Map.Entry entry = iter.next();
            dispatcher = (MessageDispatcher)entry.getValue();
            sc.setAttribute(DISPATCHER, (Object)dispatcher);
        }
        return dispatcher;
    }

    public void destroy() {
    }
}

