/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.action.httpclient;

import cn.ymotel.dactor.action.httpclient.ActorHttpClientResponseHandler;
import cn.ymotel.dactor.action.httpclient.HttpClientActor;
import cn.ymotel.dactor.message.Message;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;

public class ActorHttpClientResponse
implements ActorHttpClientResponseHandler {
    private static final Log logger = LogFactory.getLog(ActorHttpClientResponse.class);

    @Override
    public void handleResponse(HttpResponse response, HttpClientContext httpclientcontext, String charset, Message message) throws Exception {
        String result = ActorHttpClientResponse.handleInner(response, charset);
        message.getContext().put(HttpClientActor.RESPONSE, result);
        message.getControlMessage().getMessageDispatcher().sendMessage(message);
    }

    public static String handleInner(HttpResponse response, String charset) throws IOException, HttpResponseException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        try {
            if (statusLine.getStatusCode() >= 300) {
                EntityUtils.consume((HttpEntity)entity);
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            if (entity == null) {
                String string = null;
                return string;
            }
            Charset charset1 = null;
            if (charset != null) {
                charset1 = Charset.forName(charset);
            } else {
                ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
                charset1 = contentType.getCharset();
                if (charset1 == null || "".equals(charset1.toString())) {
                    byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity);
                    charset1 = Charset.forName(ActorHttpClientResponse.getContentCharSet(bytes));
                    String string = new String(bytes, charset1);
                    return string;
                }
                if (charset1 == null || "".equals(charset1.toString())) {
                    charset1 = Charset.forName(charset);
                }
            }
            String ss = EntityUtils.toString((HttpEntity)entity, (Charset)charset1);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("handleInner(HttpResponse, String) - http----response ----" + ss));
            }
            String string = ss;
            return string;
        }
        catch (ParseException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"handleInner(HttpResponse, String)", (Throwable)e);
            }
            throw e;
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)entity);
        }
    }

    public static String getContentCharSet(byte[] bytes) throws ParseException {
        String charSet = "";
        String regEx = "(?=<meta).*?(?<=charset=[\\'|\\\"]?)([[a-z]|[A-Z]|[0-9]|-]*)";
        Pattern p = Pattern.compile(regEx, 2);
        Matcher m = p.matcher(new String(bytes));
        boolean result = m.find();
        if (!result) {
            return "gbk";
        }
        if (m.groupCount() == 1) {
            charSet = m.group(1);
        }
        if (charSet.trim().equals("")) {
            charSet = "gbk";
        }
        return charSet;
    }
}

