/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.action;

import cn.ymotel.dactor.action.Actor;
import cn.ymotel.dactor.async.web.view.CustomHttpView;
import cn.ymotel.dactor.async.web.view.HttpView;
import cn.ymotel.dactor.message.Message;
import cn.ymotel.dactor.message.ServletMessage;
import cn.ymotel.dactor.pattern.PatternLookUpMatch;
import cn.ymotel.dactor.pattern.PatternMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.util.UrlPathHelper;

public class ViewResolveActor
implements Actor<ServletMessage>,
InitializingBean,
ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(ViewResolveActor.class);
    Map<String, HttpView> viewMap = new HashMap<String, HttpView>();
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private Map<String, HttpView> urlSuffixMap = new HashMap<String, HttpView>();
    private PatternLookUpMatch<HttpView> patternLookUpMatch = new PatternLookUpMatch();
    private ApplicationContext applicationContext;

    public Map<String, HttpView> getViewMap() {
        return this.viewMap;
    }

    public void setViewMap(Map viewMap) {
        this.viewMap = viewMap;
    }

    public void setUrlSuffixMap(Map<String, HttpView> urlSuffixMap) {
        this.urlSuffixMap = urlSuffixMap;
    }

    @Override
    public Message HandleMessage(ServletMessage message) throws Exception {
        if (message instanceof ServletMessage) {
            ServletMessage servletMessage = message;
            if (servletMessage.getAsyncContext().getResponse().isCommitted()) {
                return message;
            }
            Map dataMap = message.getContext();
            for (Map.Entry entry : dataMap.entrySet()) {
                servletMessage.getAsyncContext().getRequest().setAttribute((String)entry.getKey(), entry.getValue());
            }
            if (message.getException() != null) {
                servletMessage.getAsyncContext().getRequest().setAttribute("_EXCEPTION", (Object)message.getException());
            }
        }
        if (this.UrlPathViewExecute(message)) {
            return message;
        }
        if (this.viewExecute(message)) {
            return message;
        }
        if (this.SuffixViewExecute(message)) {
            return message;
        }
        System.err.println("can't find httpview");
        return message;
    }

    public boolean UrlPathViewExecute(ServletMessage message) {
        String UrlPath = this.urlPathHelper.getLookupPathForRequest(message.getRequest());
        HttpView httpView = this.patternLookUpMatch.lookupMatchBean(UrlPath, message.getRequest().getMethod(), message.getRequest().getServerName());
        if (httpView == null) {
            return false;
        }
        if (message.getException() == null) {
            httpView.successRender(message, null);
        } else {
            httpView.exceptionRender(message, null);
        }
        return true;
    }

    public boolean SuffixViewExecute(ServletMessage message) {
        String suffix = (String)message.getContext().get("_SUFFIX");
        if (suffix == null) {
            return false;
        }
        HttpView view = this.urlSuffixMap.get(suffix);
        if (view == null) {
            return false;
        }
        if (message.getException() == null) {
            view.successRender(message, null);
        } else {
            view.exceptionRender(message, null);
        }
        return true;
    }

    public boolean viewExecute(ServletMessage message) {
        Throwable exception = message.getException();
        String result = this.renderResultView(message);
        if (result == null) {
            return false;
        }
        String[] resolverNames = this.getResolverNames(result);
        HttpView view = this.getViewMap().get(resolverNames[0]);
        if (view == null) {
            return false;
        }
        try {
            this.ReplaceVariable(message, resolverNames);
            if (exception == null) {
                view.successRender(message, resolverNames[1]);
            } else {
                view.exceptionRender(message, resolverNames[1]);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            message.getAsyncContext().complete();
        }
        return true;
    }

    private void ReplaceVariable(ServletMessage message, String[] resolverNames) {
        if (resolverNames[1].indexOf("{") < 0) {
            return;
        }
        Object obj = message.getContextData("_Content");
        if (!(obj instanceof Map)) {
            return;
        }
        Map tMap = (Map)obj;
        for (Object s : tMap.keySet()) {
            if (resolverNames[1].indexOf("{") < 0) break;
            resolverNames[1] = resolverNames[1].replaceAll("\\{".concat(s.toString()).concat("\\}"), tMap.get(s.toString()).toString());
        }
    }

    private String[] getResolverNames(String result) {
        String[] views = result.split(":");
        String[] resolverNames = new String[2];
        if (views.length == 1) {
            if (result.endsWith(":")) {
                resolverNames[0] = views[0];
                resolverNames[1] = null;
            } else {
                resolverNames[0] = "default";
                resolverNames[1] = views[0];
            }
        } else if (views.length >= 2) {
            resolverNames[0] = views[0];
            resolverNames[1] = result.substring((views[0] + ":").length());
        }
        return resolverNames;
    }

    private boolean renderDefaultView(Message message) {
        HttpView view = this.getViewMap().get("default");
        return false;
    }

    private String renderResultView(Message message) {
        Object content = message.getContextData("_Content");
        if (content != null && content instanceof String) {
            return (String)content;
        }
        String result = null;
        result = (String)message.getControlMessage().getSourceCfg().getResults().get("success" + message.getControlMessage().getState());
        if (result == null) {
            result = (String)message.getControlMessage().getProcessStructure().getActorTransactionCfg().getResults().get("success" + message.getControlMessage().getState());
        }
        return result;
    }

    public void afterPropertiesSet() throws Exception {
        this.urlPathHelper.setAlwaysUseFullPath(true);
        Map maps = this.applicationContext.getBeansOfType(CustomHttpView.class);
        for (CustomHttpView view : maps.values()) {
            if (view.getUrlSuffix() != null) {
                this.urlSuffixMap.put(view.getUrlSuffix(), view);
            }
            if (view.getViewName() != null) {
                this.viewMap.put(view.getViewName(), view);
            }
            this.RegisterPattern(view);
        }
    }

    private void RegisterPattern(CustomHttpView view) {
        ArrayList<String> includePattern = new ArrayList<String>();
        if (view.getUrlPattern() != null) {
            includePattern.add(view.getUrlPattern());
        }
        if (view.getUrlPatterns() != null && view.getUrlPatterns().size() > 0) {
            includePattern.addAll(view.getUrlPatterns());
        }
        ArrayList<String> excludePattern = new ArrayList<String>();
        if (view.getExcludeUrlPattern() != null) {
            excludePattern.add(view.getExcludeUrlPattern());
        }
        if (view.getExcludeUrlPatterns() != null && view.getExcludeUrlPatterns().size() > 0) {
            excludePattern.addAll(view.getExcludeUrlPatterns());
        }
        this.patternLookUpMatch.add(new PatternMatcher<CustomHttpView>(includePattern, excludePattern, view));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

