/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor;

import cn.ymotel.dactor.core.ActorChainCfg;
import cn.ymotel.dactor.core.ActorTransactionCfg;
import cn.ymotel.dactor.message.Message;
import cn.ymotel.dactor.spring.annotaion.AfterChain;
import cn.ymotel.dactor.spring.annotaion.BaseChain;
import cn.ymotel.dactor.spring.annotaion.BeforeChain;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;

public class ActorUtils {
    private static ConcurrentHashMap cachedBean = new ConcurrentHashMap();

    public static Map<String, Object> getAnnotations(ApplicationContext applicationContext, Class<? extends Annotation> annotationType) {
        Map map = applicationContext.getBeansWithAnnotation(annotationType);
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        for (Map.Entry entry : map.entrySet()) {
            rtnMap.put((String)entry.getKey(), entry.getValue());
        }
        return rtnMap;
    }

    public static Object getCacheBean(ApplicationContext applicationContext, String beanName) {
        Object bean = cachedBean.get(beanName);
        if (bean != null) {
            return bean;
        }
        if (bean == null && applicationContext.containsBean(beanName)) {
            bean = applicationContext.getBean(beanName);
        }
        if (bean == null) {
            return null;
        }
        cachedBean.put(beanName, bean);
        return bean;
    }

    public static boolean containBean(ApplicationContext applicationContext, String beanName) {
        Object bean = ActorUtils.getCacheBean(applicationContext, beanName);
        return bean != null;
    }

    public static String getBeanFromTranstionId(ApplicationContext applicationContext, String beanName) {
        Object obj = null;
        if (beanName == null) {
            return null;
        }
        while (true) {
            if ((obj = ActorUtils.getCacheBean(applicationContext, beanName)) != null) {
                return beanName;
            }
            if (beanName.indexOf(".") < 0) break;
            beanName = beanName.substring(0, beanName.lastIndexOf("."));
        }
        return null;
    }

    public static String getDataKey(Message message, String defaultKey) {
        Map stempMap = message.getControlMessage().getProcessStructure().getStepMap();
        if (stempMap == null || stempMap.get("data") == null) {
            return defaultKey;
        }
        return (String)stempMap.get("data");
    }

    public static <T> T ConvertData(Object value, Class<T> clazz) {
        if (value == null) {
            return null;
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return (T)new Long(value.toString());
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return (T)new Short(value.toString());
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return (T)new Integer(value.toString());
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return (T)new BigDecimal(value.toString());
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (T)value.toString();
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return (T)new Double(value.toString());
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return (T)new Float(value.toString());
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return Enum.valueOf(clazz, value.toString());
        }
        return (T)value;
    }

    public static String getClientIP(HttpServletRequest request) {
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        return ActorUtils.getClientIPByHeader(request, headers);
    }

    public static String getClientIPByHeader(HttpServletRequest request, String ... headerNames) {
        String ip;
        for (String header : headerNames) {
            ip = request.getHeader(header);
            if (ip == null || ActorUtils.isUnknow(ip)) continue;
            return ActorUtils.getMultistageReverseProxyIp(ip);
        }
        ip = request.getRemoteAddr();
        return ActorUtils.getMultistageReverseProxyIp(ip);
    }

    private static boolean isUnknow(String checkString) {
        return StringUtils.isBlank((CharSequence)checkString) || "unknown".equalsIgnoreCase(checkString);
    }

    private static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (ActorUtils.isUnknow(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    public static ActorTransactionCfg createDefaultChainActor(ApplicationContext applicationContext, String defaultchain, String endBeanId) {
        ActorTransactionCfg cfg = new ActorTransactionCfg();
        cfg.setHandleException(true);
        if (endBeanId != null) {
            cfg.setEndBeanId(endBeanId);
        }
        cfg.setApplicationContext(applicationContext);
        HashMap map = new HashMap();
        map.putAll(ActorUtils.createChainActor("beginActor", "placeholderActor", defaultchain, BeforeChain.class, applicationContext));
        map.putAll(ActorUtils.createChainActor("placeholderActor", null, defaultchain, AfterChain.class, applicationContext));
        cfg.setSteps(map);
        return cfg;
    }

    private static TreeMap shortChain(Class<? extends Annotation> annotationType, ApplicationContext applicationContext) {
        final Map<String, Object> annotationMap = ActorUtils.getAnnotations(applicationContext, annotationType);
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Order order1 = (Order)AnnotatedElementUtils.findMergedAnnotation(annotationMap.get(o1).getClass(), Order.class);
                Order order2 = (Order)AnnotatedElementUtils.findMergedAnnotation(annotationMap.get(o2).getClass(), Order.class);
                if (order1.value() >= order2.value()) {
                    return -1;
                }
                return 1;
            }
        });
        treeMap.putAll(annotationMap);
        return treeMap;
    }

    private static Map createChainActor(String preBeanId, String endBeanId, String chainid, Class<? extends Annotation> annotationType, ApplicationContext applicationContext) {
        TreeMap annotationMap = ActorUtils.shortChain(annotationType, applicationContext);
        HashMap rtnMap = new HashMap();
        for (Map.Entry entry : annotationMap.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            BaseChain baseChain = (BaseChain)AnnotatedElementUtils.findMergedAnnotation(value.getClass(), BaseChain.class);
            String[] chains = baseChain.chain();
            if (chains != null && chains.length > 0) {
                HashSet<String> set = new HashSet<String>();
                for (int i = 0; i < chains.length; ++i) {
                    set.add(chains[i]);
                }
                if (!set.contains(chainid)) continue;
            }
            ArrayList list = new ArrayList();
            HashMap<String, String> property = new HashMap<String, String>();
            property.put("fromBeanId", preBeanId);
            property.put("toBeanId", key);
            property.put("conditon", "");
            list.add(property);
            rtnMap.put(preBeanId, list);
            preBeanId = key;
        }
        if (endBeanId != null) {
            ArrayList list = new ArrayList();
            HashMap<String, String> property = new HashMap<String, String>();
            property.put("fromBeanId", preBeanId);
            property.put("toBeanId", endBeanId);
            property.put("conditon", "");
            list.add(property);
            rtnMap.put(preBeanId, list);
        }
        return rtnMap;
    }

    public static ActorChainCfg creatDefaultChain(ApplicationContext applicationContext, String beanId, String endBeanId) {
        ActorChainCfg cfg = new ActorChainCfg();
        cfg.setId(beanId);
        ArrayList<ActorTransactionCfg> ls = new ArrayList<ActorTransactionCfg>();
        ActorTransactionCfg cfg1 = ActorUtils.createDefaultChainActor(applicationContext, beanId, endBeanId);
        cfg1.setApplicationContext(applicationContext);
        try {
            cfg1.afterPropertiesSet();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ls.add(cfg1);
        cfg.setChain(ls);
        return cfg;
    }
}

