/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.springboot;

import cn.ymotel.dactor.action.ViewResolveActor;
import cn.ymotel.dactor.async.web.AsyncServletFilter;
import cn.ymotel.dactor.async.web.view.CsvView;
import cn.ymotel.dactor.async.web.view.DownloadView;
import cn.ymotel.dactor.async.web.view.HttpView;
import cn.ymotel.dactor.async.web.view.JsonView;
import cn.ymotel.dactor.async.web.view.StreamView;
import cn.ymotel.dactor.async.web.view.UrlView;
import cn.ymotel.dactor.response.TransportResponseViewActor;
import cn.ymotel.dactor.springboot.DactorAutoConfiguration;
import java.util.HashMap;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@AutoConfigureAfter(value={DactorAutoConfiguration.class})
public class DactorServletAutoConfiguration {
    private TransportResponseViewActor transportResponseViewActor = null;

    public DactorServletAutoConfiguration(TransportResponseViewActor transportResponseViewActor) {
        this.transportResponseViewActor = transportResponseViewActor;
    }

    @Bean
    @ConditionalOnMissingBean
    public AsyncServletFilter asyncServletFilter() {
        AsyncServletFilter filter = new AsyncServletFilter();
        return filter;
    }

    @Bean
    @ConditionalOnMissingBean
    public ViewResolveActor getViewResolveActor() {
        ViewResolveActor actor = new ViewResolveActor();
        HashMap<String, HttpView> viewMap = new HashMap<String, HttpView>();
        actor.setViewMap(viewMap);
        viewMap.put("default", this.getDefaultView());
        viewMap.put("forward", this.getForwardView());
        viewMap.put("htmlstream", this.getStreamView("text/html; charset=utf-8"));
        viewMap.put("xmlstream", this.getStreamView("text/xml; charset=utf-8"));
        viewMap.put("pdfstream", this.getStreamView("application/pdf; charset=utf-8"));
        viewMap.put("json", this.getJsonView());
        viewMap.put("download", this.getDownLoadView());
        viewMap.put("stream", new StreamView());
        viewMap.put("csv", new CsvView());
        viewMap.put("img", this.getStreamView("images/*"));
        HashMap<String, HttpView> suffixViewMap = new HashMap<String, HttpView>();
        suffixViewMap.put("json", this.getJsonView());
        suffixViewMap.put("xml", this.getStreamView("text/xml; charset=utf-8"));
        suffixViewMap.put("html", this.getStreamView("text/html; charset=utf-8"));
        actor.setSuffixMap(suffixViewMap);
        this.transportResponseViewActor.getTransportMap().put("http_servlet", actor);
        return actor;
    }

    private DownloadView getDownLoadView() {
        DownloadView view = new DownloadView();
        return view;
    }

    private JsonView getJsonView() {
        JsonView view = new JsonView();
        view.setContentType("application/json;charset=UTF-8");
        view.setSuffix(".json");
        return view;
    }

    private UrlView getDefaultView() {
        UrlView view = new UrlView();
        view.setContentType("text/html; charset=utf-8");
        view.setPrefix("/WEB-INF/jsp/");
        view.setSuffix(".jsp");
        return view;
    }

    private UrlView getForwardView() {
        UrlView view = new UrlView();
        view.setSuffix(".do");
        return view;
    }

    private StreamView getStreamView(String contenttype) {
        StreamView view = new StreamView();
        view.setContentType(contenttype);
        return view;
    }
}

