/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.springboot;

import cn.ymotel.dactor.action.BeginActor;
import cn.ymotel.dactor.action.EndActor;
import cn.ymotel.dactor.action.FinishActor;
import cn.ymotel.dactor.action.PlaceholderActor;
import cn.ymotel.dactor.core.ActorChainCfg;
import cn.ymotel.dactor.core.ActorGlobalCfg;
import cn.ymotel.dactor.core.ActorTransactionCfg;
import cn.ymotel.dactor.core.MessageDispatcher;
import cn.ymotel.dactor.core.disruptor.MessageRingBufferDispatcher;
import cn.ymotel.dactor.core.disruptor.RingBufferMonitorThread;
import cn.ymotel.dactor.message.DefaultResolveMessage;
import cn.ymotel.dactor.response.TransportResponseViewActor;
import cn.ymotel.dactor.spring.annotaion.ActorCfgBeanFactoryPostProcessor;
import cn.ymotel.dactor.springboot.DactorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MessageDispatcher.class})
@EnableConfigurationProperties(value={DactorProperties.class})
@ConditionalOnProperty(name={"dactor.enabled"}, matchIfMissing=true)
public class DactorAutoConfiguration {
    @Autowired
    private DactorProperties properties = null;
    @Autowired
    private ApplicationContext applicationContext = null;

    @Bean
    @ConditionalOnMissingBean
    public ActorGlobalCfg getActorGlobalCfg() {
        return new ActorGlobalCfg();
    }

    @Bean(name={"beginActor"})
    @ConditionalOnMissingBean
    public BeginActor getBeginActor() {
        return new BeginActor();
    }

    @Bean(name={"FinishActor"})
    @ConditionalOnMissingBean
    public FinishActor getFinishActor() {
        return new FinishActor();
    }

    @Bean(name={"endActor"})
    @ConditionalOnMissingBean
    public EndActor getEndActor() {
        return new EndActor();
    }

    @Bean(name={"placeholderActor"})
    @ConditionalOnMissingBean
    public PlaceholderActor getPlaceholderActor() {
        return new PlaceholderActor();
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageDispatcher getMessageDispatcher() {
        MessageRingBufferDispatcher messageDispatcher = new MessageRingBufferDispatcher();
        messageDispatcher.setChecktime(this.properties.getChecktime());
        messageDispatcher.setMaxsize(this.properties.getThreadmin());
        messageDispatcher.setMaxsize(this.properties.getThreadmax());
        messageDispatcher.setBufferSize(this.properties.getBufferSize());
        if (this.properties.isMonitor()) {
            RingBufferMonitorThread monitorThread = new RingBufferMonitorThread();
            monitorThread.setMessageRingBufferDispatcher(messageDispatcher);
            monitorThread.start();
        }
        return messageDispatcher;
    }

    @Bean(name={"TransportResponseViewActor"})
    @ConditionalOnMissingBean
    public TransportResponseViewActor getTransportResponseViewActor() {
        return new TransportResponseViewActor();
    }

    public ActorTransactionCfg createDefaultChainActor() {
        ActorTransactionCfg cfg = new ActorTransactionCfg();
        cfg.setHandleException(true);
        cfg.setEndBeanId("TransportResponseViewActor");
        cfg.setId("chainactor");
        HashMap map = new HashMap();
        ArrayList list = new ArrayList();
        HashMap<String, String> property = new HashMap<String, String>();
        property.put("fromBeanId", "beginActor");
        property.put("toBeanId", "placeholderActor");
        property.put("conditon", "");
        list.add(property);
        map.put("beginActor", list);
        cfg.setSteps(map);
        return cfg;
    }

    @Bean(name={"defaultchain"})
    @ConditionalOnMissingBean
    public ActorChainCfg creatDefaultChain() {
        ActorChainCfg cfg = new ActorChainCfg();
        cfg.setId("defaultchain");
        ArrayList<ActorTransactionCfg> ls = new ArrayList<ActorTransactionCfg>();
        ActorTransactionCfg cfg1 = this.createDefaultChainActor();
        cfg1.setApplicationContext(this.applicationContext);
        try {
            cfg1.afterPropertiesSet();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ls.add(cfg1);
        cfg.setChain(ls);
        return cfg;
    }

    @Bean(name={"DefaultResolveMessage"})
    @ConditionalOnMissingBean
    public DefaultResolveMessage getDefaultResolveMessage() {
        return new DefaultResolveMessage();
    }

    @Bean
    @ConditionalOnMissingBean
    public static ActorCfgBeanFactoryPostProcessor createActorCfgBeanFactoryPostProcessor() {
        return new ActorCfgBeanFactoryPostProcessor();
    }
}

