/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.spring.annotaion;

import cn.ymotel.dactor.core.ActorTransactionCfg;
import cn.ymotel.dactor.spring.annotaion.ActorCfg;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultBeanNameGenerator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public class ActorCfgBeanFactoryPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    private BeanDefinitionRegistry registry;
    private BeanNameGenerator beanNameGenerator = new DefaultBeanNameGenerator();

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] beans;
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)beanFactory;
        for (String s : beans = beanFactory.getBeanDefinitionNames()) {
            Class beanType = beanFactory.getType(s);
            ActorCfg actorCfg = (ActorCfg)AnnotationUtils.findAnnotation((Class)beanType, ActorCfg.class);
            if (actorCfg == null) continue;
            RootBeanDefinition rootBeanDefinition = new RootBeanDefinition();
            rootBeanDefinition.setBeanClass(ActorTransactionCfg.class);
            String name = this.beanNameGenerator.generateBeanName((BeanDefinition)rootBeanDefinition, this.registry);
            this.beanBuilder(actorCfg, s, name, defaultListableBeanFactory);
        }
    }

    public void beanBuilder(ActorCfg actorCfg, String beanid, String name, DefaultListableBeanFactory defaultListableBeanFactory) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ActorTransactionCfg.class);
        builder.addPropertyValue("beginBeanId", (Object)beanid);
        if (StringUtils.hasText((String)actorCfg.urlPatterns())) {
            builder.addPropertyValue("urlPattern", (Object)actorCfg.urlPatterns());
        }
        if (StringUtils.hasText((String)actorCfg.chain())) {
            builder.addPropertyReference("chain", actorCfg.chain());
        }
        if (StringUtils.hasText((String)actorCfg.parent())) {
            builder.addPropertyReference("parent", actorCfg.parent());
        }
        String cfgid = null;
        cfgid = actorCfg.id() == null || actorCfg.id().equals("") ? name : actorCfg.id();
        builder.addPropertyValue("domain", (Object)actorCfg.domain());
        builder.addPropertyValue("id", (Object)cfgid);
        builder.setLazyInit(false);
        defaultListableBeanFactory.registerBeanDefinition(cfgid, (BeanDefinition)builder.getRawBeanDefinition());
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.registry = registry;
    }
}

