/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.spring;

import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ApplicationContext;

public class SpringUtils {
    private static ConcurrentHashMap cachedBean = new ConcurrentHashMap();

    public static Object getCacheBean(ApplicationContext applicationContext, String beanName) {
        Object bean = cachedBean.get(beanName);
        if (bean != null) {
            return bean;
        }
        if (bean == null && applicationContext.containsBean(beanName)) {
            bean = applicationContext.getBean(beanName);
        }
        if (bean == null) {
            return null;
        }
        cachedBean.put(beanName, bean);
        return bean;
    }

    public static boolean containBean(ApplicationContext applicationContext, String beanName) {
        Object bean = SpringUtils.getCacheBean(applicationContext, beanName);
        return bean != null;
    }

    public static String getBeanFromTranstionId(ApplicationContext applicationContext, String beanName) {
        Object obj = null;
        if (beanName == null) {
            return null;
        }
        while (true) {
            if ((obj = SpringUtils.getCacheBean(applicationContext, beanName)) != null) {
                return beanName;
            }
            if (beanName.indexOf(".") < 0) break;
            beanName = beanName.substring(0, beanName.lastIndexOf("."));
        }
        return null;
    }
}

