/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.action.netty.httpserver;

import cn.ymotel.dactor.action.netty.httpserver.NettyHttpServerHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.stream.ChunkedWriteHandler;

public class NettyHttpServer {
    EventLoopGroup parentGroup = new NioEventLoopGroup();
    EventLoopGroup childGroup = new NioEventLoopGroup();
    private NettyHttpServerHandler serverHandler;
    private int port;

    public NettyHttpServerHandler getServerHandler() {
        return this.serverHandler;
    }

    public void setServerHandler(NettyHttpServerHandler serverHandler) {
        this.serverHandler = serverHandler;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void init() throws Exception {
        try {
            ServerBootstrap server = new ServerBootstrap();
            ((ServerBootstrap)server.group(this.parentGroup, this.childGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel socketChannel) throws Exception {
                    socketChannel.pipeline().addLast("http-decoder", (ChannelHandler)new HttpRequestDecoder());
                    socketChannel.pipeline().addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(65535));
                    socketChannel.pipeline().addLast("http-encoder", (ChannelHandler)new HttpResponseEncoder());
                    socketChannel.pipeline().addLast("http-chunked", (ChannelHandler)new ChunkedWriteHandler());
                    socketChannel.pipeline().addLast("http-server", (ChannelHandler)NettyHttpServer.this.serverHandler);
                }
            });
            server.bind(this.port);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.childGroup.shutdownGracefully();
        this.parentGroup.shutdownGracefully();
    }

    public static void main(String[] args) {
        NettyHttpServer server = new NettyHttpServer();
        server.setPort(8080);
        try {
            server.init();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("exception: " + e.getMessage());
        }
        System.out.println("server close!");
    }
}

