/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.action.netty.aysnsocket;

import cn.ymotel.dactor.action.netty.aysnsocket.TcpClientHanlder;
import cn.ymotel.dactor.message.Message;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.InitializingBean;

public class TcpClientHelper
implements InitializingBean {
    private String host = "localhost";
    private int port = 8810;
    private TcpClientHanlder tcpClientHanlder;
    private Proxy proxy;
    private long readerIdleTime = 10000L;
    private long writerIdleTime = 10000L;
    private long allIdleTime = 10000L;
    private int connect_timeout = 10000;
    private Bootstrap bootstrap;
    private static final StringDecoder DECODER = new StringDecoder();
    private static final StringEncoder ENCODER = new StringEncoder();

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public long getReaderIdleTime() {
        return this.readerIdleTime;
    }

    public void setReaderIdleTime(long readerIdleTime) {
        this.readerIdleTime = readerIdleTime;
    }

    public long getWriterIdleTime() {
        return this.writerIdleTime;
    }

    public void setWriterIdleTime(long writerIdleTime) {
        this.writerIdleTime = writerIdleTime;
    }

    public long getAllIdleTime() {
        return this.allIdleTime;
    }

    public void setAllIdleTime(long allIdleTime) {
        this.allIdleTime = allIdleTime;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public TcpClientHanlder getTcpClientHanlder() {
        return this.tcpClientHanlder;
    }

    public void setTcpClientHanlder(TcpClientHanlder tcpClientHanlder) {
        this.tcpClientHanlder = tcpClientHanlder;
    }

    public static void main(String[] args) throws Exception {
        TcpClientHelper helper = new TcpClientHelper();
        TcpClientHanlder handler = new TcpClientHanlder();
        helper.setTcpClientHanlder(handler);
        helper.afterPropertiesSet();
        helper.AsyncSendMessage(null, "safafafcafaaa\r\n");
        System.out.println("success");
    }

    public void AsyncSendMessage(final Message message, final Object obj) {
        this.bootstrap.connect(this.host, this.port).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                Channel channel = future.channel();
                channel.attr(TcpClientHanlder.MESSAGE).setIfAbsent((Object)message);
                channel.writeAndFlush((Object)(obj + "\r\n"));
            }
        });
    }

    public Channel getChannel() throws InterruptedException {
        return this.bootstrap.connect(this.host, this.port).sync().channel();
    }

    public void afterPropertiesSet() throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup();
        Bootstrap b = new Bootstrap();
        b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connect_timeout);
        b.option(ChannelOption.TCP_NODELAY, (Object)true);
        ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(TcpClientHelper.this.readerIdleTime, TcpClientHelper.this.writerIdleTime, TcpClientHelper.this.allIdleTime, TimeUnit.MILLISECONDS)});
                if (TcpClientHelper.this.proxy != null && !TcpClientHelper.this.proxy.type().equals((Object)Proxy.Type.DIRECT)) {
                    if (TcpClientHelper.this.proxy.type().equals((Object)Proxy.Type.HTTP)) {
                        pipeline.addFirst(new ChannelHandler[]{new HttpProxyHandler(TcpClientHelper.this.proxy.address())});
                    } else if (TcpClientHelper.this.proxy.type().equals((Object)Proxy.Type.SOCKS)) {
                        pipeline.addFirst(new ChannelHandler[]{new Socks5ProxyHandler(TcpClientHelper.this.proxy.address())});
                    }
                }
                pipeline.addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(8192, Delimiters.lineDelimiter())});
                pipeline.addLast(new ChannelHandler[]{DECODER});
                pipeline.addLast(new ChannelHandler[]{ENCODER});
                pipeline.addLast(new ChannelHandler[]{TcpClientHelper.this.tcpClientHanlder});
            }
        });
        this.bootstrap = b;
    }
}

