/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.async.web;

import cn.ymotel.dactor.async.web.DActorAsyncListener;
import cn.ymotel.dactor.core.ActorTransactionCfg;
import cn.ymotel.dactor.core.UrlMapping;
import cn.ymotel.dactor.core.disruptor.MessageRingBufferDispatcher;
import cn.ymotel.dactor.message.DefaultResolveMessage;
import cn.ymotel.dactor.message.Message;
import cn.ymotel.dactor.spring.SpringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.support.JstlUtils;
import org.springframework.web.util.UrlPathHelper;

public class AsyncServletFilter
implements Filter {
    private static final Log logger = LogFactory.getLog(AsyncServletFilter.class);
    private WebApplicationContext applicationContext;
    private long timeout = 900000L;
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private DefaultResolveMessage defaultResolveMessage = null;
    public static String messageSourceId = "messageSource";
    private int errorcode = 429;
    private AntPathMatcher antPathMatcher = new AntPathMatcher();
    private static final String DISPATCHER = WebApplicationContext.class.getName() + ".dispatchers";

    public WebApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(WebApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.init(filterConfig.getServletContext(), filterConfig.getInitParameter("errcode"));
    }

    public void init(ServletContext servletContext, String errcode) {
        this.setApplicationContext(WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext));
        String serrcode = errcode;
        if (serrcode != null && !serrcode.trim().equals("")) {
            try {
                this.errorcode = Integer.parseInt(serrcode);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        this.urlPathHelper.setAlwaysUseFullPath(true);
        this.defaultResolveMessage = (DefaultResolveMessage)SpringUtils.getCacheBean((ApplicationContext)this.getApplicationContext(), "DefaultResolveMessage");
        if (this.defaultResolveMessage == null) {
            this.defaultResolveMessage = new DefaultResolveMessage();
        }
    }

    public void doFilter(ServletRequest request1, ServletResponse response1, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)request1;
        HttpServletResponse response = (HttpServletResponse)response1;
        if (!this.doService(request, response)) {
            chain.doFilter(request1, response1);
        }
    }

    public boolean doService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        MessageSource messageSource = (MessageSource)SpringUtils.getCacheBean((ApplicationContext)this.getApplicationContext(), messageSourceId);
        JstlUtils.exposeLocalizationContext((HttpServletRequest)request, (MessageSource)messageSource);
        String UrlPath = this.urlPathHelper.getLookupPathForRequest(request);
        ActorTransactionCfg cfg = null;
        Object requestHandler = this.getRequestHandler(request, UrlPath);
        if (requestHandler == null) {
            return false;
        }
        if (requestHandler instanceof HttpRequestHandler) {
            ((HttpRequestHandler)requestHandler).handleRequest(request, response);
            return true;
        }
        if (requestHandler instanceof ActorTransactionCfg) {
            cfg = (ActorTransactionCfg)requestHandler;
            this.HandleAsyncContext(request, response, cfg, UrlPath);
            return true;
        }
        return false;
    }

    public void HandleAsyncContext(HttpServletRequest request, HttpServletResponse response, ActorTransactionCfg cfg, String UrlPath) throws IOException {
        String suffix = null;
        if (UrlPath.lastIndexOf(".") >= 0) {
            suffix = UrlPath.substring(UrlPath.lastIndexOf(".") + 1);
        }
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.addListener((AsyncListener)new DActorAsyncListener());
        asyncContext.setTimeout(this.timeout);
        Message message = this.defaultResolveMessage.resolveContext(asyncContext, request, response);
        Map params = this.getUrlmap(UrlPath, cfg, request);
        message.getContext().putAll(params);
        message.getContext().put("_METHOD", request.getMethod());
        message.getContext().put("_SUFFIX", suffix);
        this.addTransPort(message);
        try {
            boolean b = this.getDispatcher(request.getServletContext()).startMessage(message, cfg, false);
            if (!b) {
                ((HttpServletResponse)asyncContext.getResponse()).sendError(this.errorcode);
                asyncContext.complete();
                return;
            }
        }
        catch (Exception e) {
            asyncContext.getResponse().setContentType("text/html; charset=utf-8");
            asyncContext.getRequest().setAttribute("_EXCEPTION", (Object)e);
            asyncContext.getResponse().getWriter().print(e.getMessage());
            asyncContext.getResponse().getWriter().flush();
            asyncContext.complete();
        }
    }

    protected void addTransPort(Message message) {
        message.getControlData().put("transport", "http_servlet");
    }

    public Object getRequestHandler(HttpServletRequest request, String UrlPath) {
        Object bean;
        String transactionId = this.resolveTransactionId(UrlPath, request);
        transactionId = SpringUtils.getBeanFromTranstionId((ApplicationContext)this.getApplicationContext(), transactionId);
        if (transactionId != null && (bean = SpringUtils.getCacheBean((ApplicationContext)this.getApplicationContext(), transactionId)) instanceof ActorTransactionCfg && this.matchDomain((ActorTransactionCfg)bean, request.getServerName())) {
            return bean;
        }
        return this.UrlPatternHandler(UrlPath, request);
    }

    private Object UrlPatternHandler(String UrlPath, HttpServletRequest request) {
        Map.Entry matchentry = null;
        Map mapping = UrlMapping.getMapping();
        String serverName = request.getServerName();
        for (Map.Entry entry : mapping.entrySet()) {
            if (UrlPath.equals("/") && entry.getKey().equals("/")) {
                matchentry = entry;
                if (this.matchDomain(entry, serverName)) break;
            }
            if (!this.antPathMatcher.match((String)entry.getKey(), UrlPath) || !this.matchDomain(entry, serverName)) continue;
            if (matchentry == null) {
                matchentry = entry;
                continue;
            }
            if (((String)matchentry.getKey()).length() >= ((String)entry.getKey()).length()) continue;
            matchentry = entry;
        }
        if (matchentry == null) {
            return null;
        }
        return matchentry.getValue();
    }

    private boolean matchDomain(Map.Entry entry, String serverName) {
        ActorTransactionCfg cfg = (ActorTransactionCfg)entry.getValue();
        return this.matchDomain(cfg, serverName);
    }

    private boolean matchDomain(ActorTransactionCfg cfg, String serverName) {
        if (cfg.getDomain() == null || cfg.getDomain().trim().equals("")) {
            return true;
        }
        String[] domains = cfg.getDomain().split(",");
        for (int i = 0; i < domains.length; ++i) {
            if (!domains[i].equals(serverName)) continue;
            return true;
        }
        return false;
    }

    public Map getUrlmap(String urlPath, ActorTransactionCfg cfg, HttpServletRequest request) {
        if (cfg.getUrlPattern() == null || cfg.getUrlPattern().trim().equals("")) {
            return new HashMap();
        }
        String[] pattern = cfg.getUrlPattern().split(",");
        for (int i = 0; i < pattern.length; ++i) {
            if (!this.antPathMatcher.match(pattern[i], urlPath)) continue;
            return this.antPathMatcher.extractUriTemplateVariables(pattern[i], urlPath);
        }
        return new HashMap();
    }

    protected String resolveTransactionId(String path, HttpServletRequest request) {
        if (path == null || path.equals("/")) {
            return null;
        }
        int lastindex = path.lastIndexOf(".");
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (lastindex >= 0) {
            return path.substring(0, path.lastIndexOf(".")).replaceAll("/", ".");
        }
        return path.replaceAll("/", ".");
    }

    public MessageRingBufferDispatcher getDispatcher(ServletContext sc) {
        if (sc.getAttribute(DISPATCHER) != null) {
            return (MessageRingBufferDispatcher)sc.getAttribute(DISPATCHER);
        }
        MessageRingBufferDispatcher dispatcher = (MessageRingBufferDispatcher)SpringUtils.getCacheBean((ApplicationContext)this.getApplicationContext(), "MessageRingBufferDispatcher");
        sc.setAttribute(DISPATCHER, (Object)dispatcher);
        return dispatcher;
    }

    public void destroy() {
    }
}

