/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.action.netty.aysnsocket;

import cn.ymotel.dactor.action.netty.aysnsocket.TcpServerHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import org.springframework.beans.factory.InitializingBean;

public class TcpServer
implements InitializingBean {
    private int port = 8810;
    private TcpServerHandler tcpServerhandler;
    private EventLoopGroup bossGroup = new NioEventLoopGroup();
    private EventLoopGroup workerGroup = new NioEventLoopGroup();
    private static final StringDecoder DECODER = new StringDecoder();
    private static final StringEncoder ENCODER = new StringEncoder();

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public TcpServerHandler getTcpServerhandler() {
        return this.tcpServerhandler;
    }

    public void setTcpServerhandler(TcpServerHandler tcpServerhandler) {
        this.tcpServerhandler = tcpServerhandler;
    }

    public void close() {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }

    public static void main(String[] args) throws Exception {
        TcpServer helper = new TcpServer();
        TcpServerHandler handler = new TcpServerHandler();
        helper.setTcpServerhandler(handler);
        helper.afterPropertiesSet();
    }

    public void afterPropertiesSet() throws Exception {
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)1024)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(8192, Delimiters.lineDelimiter())});
                ch.pipeline().addLast(new ChannelHandler[]{DECODER});
                ch.pipeline().addLast(new ChannelHandler[]{ENCODER});
                ch.pipeline().addLast(new ChannelHandler[]{TcpServer.this.tcpServerhandler});
            }
        });
        b.bind(this.port);
    }
}

