/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.core.disruptor;

import cn.ymotel.dactor.core.disruptor.MessageEvent;
import cn.ymotel.dactor.core.disruptor.MessageEventHandler;
import cn.ymotel.dactor.core.disruptor.MessageRingBufferDispatcher;
import cn.ymotel.dactor.core.disruptor.Sentinel;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.IgnoreExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.WorkProcessorExt;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.springframework.context.ApplicationContext;

public class WorkProcessorManager {
    private ExecutorService executor = null;
    private MessageRingBufferDispatcher messageRingBufferDispatcher;
    private ApplicationContext appcontext = null;
    private RingBuffer<MessageEvent> ringBuffer;
    private Sentinel sentinel;
    private List<WorkProcessorExt> processorList = new ArrayList<WorkProcessorExt>();
    private final Sequence workSequence = new Sequence(-1L);

    public List<WorkProcessorExt> getProcessorList() {
        return this.processorList;
    }

    public RingBuffer<MessageEvent> getRingBuffer() {
        return this.ringBuffer;
    }

    public WorkProcessorManager(ExecutorService executor, MessageRingBufferDispatcher messageRingBufferDispatcher, ApplicationContext appcontext, RingBuffer<MessageEvent> ringBuffer, Sentinel sentinel) {
        this.executor = executor;
        this.messageRingBufferDispatcher = messageRingBufferDispatcher;
        this.appcontext = appcontext;
        this.ringBuffer = ringBuffer;
        this.sentinel = sentinel;
    }

    private WorkProcessorExt<MessageEvent> createProcessor(RingBuffer<MessageEvent> ringBuffer, WorkHandler workHandler) {
        return new WorkProcessorExt<MessageEvent>(ringBuffer, ringBuffer.newBarrier(new Sequence[0]), (WorkHandler<MessageEvent>)workHandler, (ExceptionHandler<MessageEvent>)new IgnoreExceptionHandler(), this.workSequence);
    }

    public void incrOneConsumer() {
        MessageEventHandler handler = this.createWorkHandler();
        WorkProcessorExt<MessageEvent> processor = this.createProcessor(this.ringBuffer, handler);
        this.processorList.add(processor);
        this.ringBuffer.addGatingSequences(new Sequence[]{processor.getSequence()});
        this.executor.execute((Runnable)((Object)processor));
    }

    public void incrConsumer(int count) {
        for (int i = 0; i < count; ++i) {
            this.incrOneConsumer();
        }
    }

    public void decrOneConsumer() {
        WorkProcessorExt tprocessor = this.processorList.get(0);
        tprocessor.halt();
        this.ringBuffer.removeGatingSequence(tprocessor.getSequence());
        this.processorList.remove(tprocessor);
    }

    public void shutdown() {
        while (this.processorList.size() > 0) {
            this.decrOneConsumer();
        }
    }

    public MessageEventHandler createWorkHandler() {
        MessageEventHandler handler = new MessageEventHandler();
        handler.setApplicationContext(this.appcontext);
        handler.setDispatcher(this.messageRingBufferDispatcher);
        handler.setSentinel(this.sentinel);
        return handler;
    }
}

