/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.core.disruptor;

import cn.ymotel.dactor.core.disruptor.WorkProcessorManager;
import java.util.concurrent.atomic.AtomicInteger;

public class Sentinel
implements Runnable {
    private WorkProcessorManager workProcessorManager = null;
    private AtomicInteger processingConsumerNumber = new AtomicInteger(0);
    private int minsize = -1;
    private int maxsize = -1;

    public AtomicInteger getProcessingConsumerNumber() {
        return this.processingConsumerNumber;
    }

    public void setWorkProcessorManager(WorkProcessorManager workProcessorManager) {
        this.workProcessorManager = workProcessorManager;
    }

    public int getMinsize() {
        return this.minsize;
    }

    public void setMinsize(int minsize) {
        this.minsize = minsize;
    }

    public int getMaxsize() {
        return this.maxsize;
    }

    public void setMaxsize(int maxsize) {
        this.maxsize = maxsize;
    }

    @Override
    public void run() {
        long workingprocess = (long)this.workProcessorManager.getRingBuffer().getBufferSize() - this.workProcessorManager.getRingBuffer().remainingCapacity();
        int processorListSize = this.workProcessorManager.getProcessorList().size();
        int processingConsumersize = this.processingConsumerNumber.get();
        if (workingprocess <= (long)this.minsize && processorListSize <= this.minsize) {
            return;
        }
        if (workingprocess > (long)processorListSize) {
            long incrn;
            if (processorListSize > processingConsumersize) {
                return;
            }
            if (this.maxsize != -1 && workingprocess > (long)this.maxsize) {
                workingprocess = this.maxsize;
            }
            if ((incrn = workingprocess - (long)processorListSize) <= 0L) {
                return;
            }
            long mod = (incrn /= 2L) % 2L;
            if (mod != 0L) {
                ++incrn;
            }
            int i = 0;
            while ((long)i < incrn) {
                this.workProcessorManager.incrOneConsumer();
                ++i;
            }
        } else {
            if (processorListSize <= this.minsize) {
                return;
            }
            if (processorListSize == processingConsumersize) {
                return;
            }
            long inum = (long)processorListSize - workingprocess - (long)processingConsumersize;
            if ((long)processorListSize - inum <= (long)this.minsize) {
                inum = processorListSize - this.minsize;
            }
            if (inum <= 0L) {
                return;
            }
            this.workProcessorManager.decrOneConsumer();
        }
    }
}

