/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.core.disruptor;

import cn.ymotel.dactor.core.AbstractMessageDispatcher;
import cn.ymotel.dactor.core.disruptor.RingBufferManager;
import cn.ymotel.dactor.message.Message;
import com.lmax.disruptor.WaitStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class MessageRingBufferDispatcher
extends AbstractMessageDispatcher
implements InitializingBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private RingBufferManager ringbufferManager;
    private int bufferSize = 1024;
    private WaitStrategy strategy = null;
    private int minsize = -1;
    private int maxsize = 300;
    private int checktime = 1000;

    @Override
    public boolean putMessageInDispatcher(Message message, boolean blocked) {
        if (message.getControlMessage().getDownStack().isEmpty()) {
            return true;
        }
        if (message.getControlMessage().getProcessStructure().getFromBeanId() == null) {
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("beanId--" + message.getControlMessage().getProcessStructure().getFromBeanId() + "--Id--" + message.getControlMessage().getProcessStructure().getActorTransactionCfg().getId()));
        }
        return this.ringbufferManager.putMessage(message, blocked);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public WaitStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(WaitStrategy strategy) {
        this.strategy = strategy;
    }

    public void setMinsize(int minsize) {
        this.minsize = minsize;
    }

    @Deprecated
    public void setThreadNumber(int threadNumber) {
        this.minsize = threadNumber;
    }

    public void setMaxsize(int maxsize) {
        this.maxsize = maxsize;
    }

    public void setChecktime(int checktime) {
        this.checktime = checktime;
    }

    public void afterPropertiesSet() throws Exception {
        this.ringbufferManager = new RingBufferManager();
        if (this.minsize == -1) {
            this.minsize = Runtime.getRuntime().availableProcessors();
        }
        this.ringbufferManager.setBufferSize(this.bufferSize);
        this.ringbufferManager.setMinsize(this.minsize);
        if (this.strategy != null) {
            this.ringbufferManager.setStrategy(this.getStrategy());
        }
        this.ringbufferManager.setApplicationContext(this.getApplicationContext());
        this.ringbufferManager.setChecktime(this.checktime);
        this.ringbufferManager.setMaxsize(this.maxsize);
        this.ringbufferManager.setMessageRingBufferDispatcher(this);
        this.ringbufferManager.afterPropertiesSet();
    }

    public RingBufferManager getRingbufferManager() {
        return this.ringbufferManager;
    }

    public void setRingbufferManager(RingBufferManager ringbufferManager) {
        this.ringbufferManager = ringbufferManager;
    }

    public void shutdown() {
        this.ringbufferManager.shutdown();
    }
}

