/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.core.disruptor;

import cn.ymotel.dactor.action.Actor;
import cn.ymotel.dactor.core.disruptor.MessageEvent;
import cn.ymotel.dactor.core.disruptor.MessageRingBufferDispatcher;
import cn.ymotel.dactor.core.disruptor.Sentinel;
import cn.ymotel.dactor.message.Message;
import cn.ymotel.dactor.spring.SpringUtils;
import cn.ymotel.dactor.workflow.ActorProcessStructure;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.LifecycleAware;
import com.lmax.disruptor.WorkHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MessageEventHandler
implements EventHandler<MessageEvent>,
WorkHandler<MessageEvent>,
ApplicationContextAware,
LifecycleAware {
    private Sentinel sentinel;
    private final Log logger = LogFactory.getLog(MessageEventHandler.class);
    private MessageRingBufferDispatcher dispatcher;
    private ApplicationContext appcontext = null;

    public void setSentinel(Sentinel sentinel) {
        this.sentinel = sentinel;
    }

    public MessageRingBufferDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(MessageRingBufferDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appcontext = applicationContext;
    }

    public void onEvent(MessageEvent event, long sequence, boolean endOfBatch) throws Exception {
        this.onEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEvent(ActorProcessStructure struc, Message message, Actor actor) {
        this.sentinel.getProcessingConsumerNumber().incrementAndGet();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("beanId--" + struc.getFromBeanId() + "--Id--" + struc.getActorTransactionCfg().getId()));
        }
        try {
            Object obj = actor.HandleMessage(message);
            if (struc.getActorTransactionCfg().getBeginBeanId().equals(struc.getFromBeanId())) {
                struc.setBeginExecute(true);
            }
            if (struc.getActorTransactionCfg().getEndBeanId().equals(struc.getFromBeanId())) {
                struc.setEndExecute(true);
            }
            if (obj != null && obj instanceof Message) {
                this.dispatcher.sendMessage(message);
            }
        }
        catch (Throwable exception) {
            message.setException(exception);
            if (struc.getActorTransactionCfg().getBeginBeanId().equals(struc.getFromBeanId())) {
                struc.setBeginExecute(true);
            }
            if (struc.getActorTransactionCfg().getEndBeanId().equals(struc.getFromBeanId())) {
                struc.setEndExecute(true);
            }
            this.dispatcher.sendMessage(message);
        }
        finally {
            this.sentinel.getProcessingConsumerNumber().decrementAndGet();
        }
    }

    public void onEvent(MessageEvent event) throws Exception {
        Message message = event.getMessage();
        if (message == null) {
            return;
        }
        ActorProcessStructure struc = message.getControlMessage().getProcessStructure();
        if (struc == null) {
            return;
        }
        if (struc.getFromBeanId() == null || struc.getFromBeanId().trim().equals("")) {
            return;
        }
        Actor actor = (Actor)SpringUtils.getCacheBean(this.appcontext, struc.getFromBeanId());
        this.handleEvent(struc, message, actor);
    }

    public void onStart() {
    }

    public void onShutdown() {
    }
}

