/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.core;

import cn.ymotel.dactor.core.ActorChainCfg;
import cn.ymotel.dactor.core.ActorTransactionCfg;
import cn.ymotel.dactor.core.MessageDispatcher;
import cn.ymotel.dactor.message.Message;
import cn.ymotel.dactor.message.SpringControlMessage;
import cn.ymotel.dactor.workflow.WorkFlowProcess;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractMessageDispatcher
implements MessageDispatcher,
ApplicationContextAware {
    private ApplicationContext appcontext = null;
    private final Log logger = LogFactory.getLog(AbstractMessageDispatcher.class);

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appcontext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.appcontext;
    }

    public abstract boolean putMessageInDispatcher(Message var1, boolean var2);

    @Override
    public boolean sendMessage(Message message) {
        SpringControlMessage cMsg = message.getControlMessage();
        if (cMsg == null) {
            return false;
        }
        if (message.getControlMessage().getProcessStructure() == null) {
            return false;
        }
        WorkFlowProcess.processGetToBeanId(message.getControlMessage(), message, this.appcontext);
        return this.putMessageInDispatcher(message, true);
    }

    @Override
    public boolean startMessage(Message message, ActorTransactionCfg actorcfg, boolean blocked) throws Exception {
        return this.startMessage(message, actorcfg, actorcfg.getChain(), blocked);
    }

    @Override
    public boolean startMessage(Message message, ActorTransactionCfg actorcfg, ActorChainCfg chain) throws Exception {
        return this.startMessage(message, actorcfg, chain, true);
    }

    @Override
    public boolean startMessage(Message message, ActorTransactionCfg actorcfg, ActorChainCfg chain, boolean blocked) throws Exception {
        SpringControlMessage cMsg = new SpringControlMessage();
        cMsg.setMessageDispatcher(this);
        cMsg.init(actorcfg, chain);
        message.setControlMessage(cMsg);
        return this.putMessageInDispatcher(message, blocked);
    }

    @Override
    public boolean startMessage(Message message, ActorTransactionCfg actorcfg) throws Exception {
        return this.startMessage(message, actorcfg, true);
    }
}

