/*
 * Decompiled with CFR 0.152.
 */
package cn.ymotel.dactor.async.web.view;

import cn.ymotel.dactor.async.web.view.AbstractView;
import cn.ymotel.dactor.message.ServletMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamView
extends AbstractView {
    private static final Log logger = LogFactory.getLog(StreamView.class);
    private String content = "_Content";

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public void renderInner(ServletMessage message, String defaultMessage) {
        block3: {
            Object obj = message.getContext().get(this.content);
            if (obj == null) {
                obj = defaultMessage;
            }
            this.WriteString(obj, message.getAsyncContext().getResponse());
            this.WriteStream(obj, message.getAsyncContext().getResponse());
            this.WriteBytes(obj, message.getAsyncContext().getResponse());
            this.WriteFile(obj, message.getAsyncContext().getResponse());
            try {
                message.getAsyncContext().complete();
            }
            catch (Exception e) {
                if (!logger.isTraceEnabled()) break block3;
                logger.trace((Object)"renderInner(LocalServletMessage, String)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void WriteFile(Object obj, ServletResponse response) {
        if (!(obj instanceof File)) {
            return;
        }
        FileInputStream fin = null;
        try {
            fin = new FileInputStream((File)obj);
            IOUtils.copyLarge((InputStream)fin, (OutputStream)response.getOutputStream());
            response.getOutputStream().flush();
        }
        catch (FileNotFoundException e) {
            block7: {
                if (!logger.isTraceEnabled()) break block7;
                logger.trace((Object)"WriteFile(Object, ServletResponse)");
            }
            IOUtils.closeQuietly((InputStream)fin);
        }
        catch (IOException e2) {
            block8: {
                if (!logger.isTraceEnabled()) break block8;
                logger.trace((Object)"WriteFile(Object, ServletResponse)");
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fin);
                        throw throwable;
                    }
                }
            }
            IOUtils.closeQuietly((InputStream)fin);
        }
        IOUtils.closeQuietly((InputStream)fin);
    }

    public void WriteString(Object obj, ServletResponse response) {
        block3: {
            if (!(obj instanceof String)) {
                return;
            }
            try {
                response.getWriter().print(obj);
                response.getWriter().flush();
            }
            catch (IOException e) {
                if (!logger.isTraceEnabled()) break block3;
                logger.trace((Object)"WriteString(Object, javax.servlet.ServletResponse)");
            }
        }
    }

    public void WriteStream(Object obj, ServletResponse response) {
        block8: {
            InputStream input;
            block7: {
                input = null;
                if (!(obj instanceof InputStream)) {
                    return;
                }
                try {
                    byte[] buffer = new byte[4096];
                    int n = 0;
                    while (-1 != (n = input.read(buffer))) {
                        response.getOutputStream().write(buffer, 0, n);
                    }
                    response.getOutputStream().flush();
                }
                catch (IOException e) {
                    if (!logger.isTraceEnabled()) break block7;
                    logger.trace((Object)"WriteStream(Object, javax.servlet.ServletResponse)");
                }
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    if (!logger.isTraceEnabled()) break block8;
                    logger.trace((Object)"WriteStream(Object, javax.servlet.ServletResponse)");
                }
            }
        }
    }

    public void WriteBytes(Object bs, ServletResponse response) {
        block3: {
            if (!(bs instanceof byte[])) {
                return;
            }
            try {
                response.getOutputStream().write((byte[])bs);
                response.getOutputStream().flush();
            }
            catch (IOException e) {
                if (!logger.isTraceEnabled()) break block3;
                logger.trace((Object)"WriteBytes(Object, javax.servlet.ServletResponse)");
            }
        }
    }
}

